/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.impl;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.openshift.api.KieServerOpenShift;
import org.kie.server.services.openshift.impl.storage.cloud.CloudClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftStartupStrategy
implements StartupStrategy {
    private static final String KIE_SERVER_ROLLOUT_IN_PROGRESS = "kieserver-rollout-in-progress";
    private static final String KIE_SERVER_INSTANCE_ID = "kieserver-" + UUID.randomUUID().toString();
    private static final String ROLLOUT_TRIGGER_TIMESTAMP = "services.server.kie.org/openshift-startup-strategy.changeTimestamp";
    private static final Logger logger = LoggerFactory.getLogger(OpenShiftStartupStrategy.class);
    private static Supplier<OpenShiftClient> clouldClientHelper = () -> new CloudClientFactory(){}.createOpenShiftClient();

    public void startup(KieServerImpl kieServer, ContainerManager containerManager, KieServerState currentState, AtomicBoolean kieServerActive) {
        String kieServerId = currentState.getConfiguration().getConfigItemValue("org.kie.server.id");
        try (OpenShiftClient client = clouldClientHelper.get();){
            Set containers = this.prepareContainers(currentState.getContainers());
            containerManager.installContainersSync(kieServer, containers, currentState, new KieServerSetup());
            new Thread(new WatchRunner(kieServerId)).start();
            OpenShiftStartupStrategy.clearRollout(client, kieServerId);
        }
    }

    private static void clearRollout(OpenShiftClient client, String kieServerId) {
        String triggerName = "kieserver-rollout-in-progress-" + kieServerId;
        if (((Boolean)((Resource)client.configMaps().withName(triggerName)).delete()).booleanValue()) {
            logger.info("Kie server: {}, DC rollout - End", (Object)KIE_SERVER_INSTANCE_ID);
        }
    }

    public String getRepositoryType() {
        return "KieServerStateOpenShiftRepository";
    }

    public String toString() {
        return "OpenShiftStartupStrategy - deploys only kie containers defined from OpenShift ConfigMap, ignores kie containers given by controller";
    }

    private static class WatchRunner
    implements Runnable,
    KieServerOpenShift {
        private boolean isWatchRunning = true;
        private String kieServerId;

        public WatchRunner(String serverId) {
            this.kieServerId = serverId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (final OpenShiftClient client = (OpenShiftClient)clouldClientHelper.get();){
                logger.info("Watching ConfigMap in namespace: [{}]", (Object)client.getNamespace());
                try (Watch watchable = (Watch)((FilterWatchListDeletable)client.configMaps().withLabel("services.server.kie.org/kie-server-id", this.kieServerId)).watch((Object)new Watcher<ConfigMap>(){

                    public void eventReceived(Watcher.Action action, ConfigMap kieServerState) {
                        logger.debug("Event - Action: {}, {} on ConfigMap ", (Object)action, (Object)kieServerState.getMetadata().getLabels().getOrDefault("services.server.kie.org/kie-server-id", "unknown"));
                        this.getKieServerDC(client, kieServerId).ifPresent(dc -> {
                            if (action.equals((Object)Watcher.Action.MODIFIED) && this.isRolloutRequired(client, kieServerId, this.isDCStable((DeploymentConfig)dc))) {
                                ObjectMeta md = dc.getSpec().getTemplate().getMetadata();
                                Map<String, String> ann = md.getAnnotations() == null ? new HashMap() : md.getAnnotations();
                                md.setAnnotations(ann);
                                ann.put(OpenShiftStartupStrategy.ROLLOUT_TRIGGER_TIMESTAMP, ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
                                client.deploymentConfigs().createOrReplace((Object[])new DeploymentConfig[]{dc});
                                logger.info("Updated DeploymentConfig: {}", (Object)md.getName());
                            } else {
                                logger.debug("Event - Ignored");
                            }
                        });
                    }

                    public void onClose(KubernetesClientException cause) {
                        logger.info("Watcher closed.");
                        if (cause != null) {
                            logger.info(cause.getMessage());
                        }
                    }
                });){
                    logger.info("Watcher created");
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        WatchRunner watchRunner = this;
                        synchronized (watchRunner) {
                            this.isWatchRunning = false;
                            this.notifyAll();
                            logger.info("ShutdownHook sent notifyAll");
                        }
                    }));
                    WatchRunner watchRunner = this;
                    synchronized (watchRunner) {
                        while (this.isWatchRunning && !Thread.currentThread().isInterrupted()) {
                            logger.info("WatchRunner thread run");
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                logger.error("WatchRunner thread being interrupted", (Throwable)e);
                            }
                            logger.info("WatchRunner thread being notified");
                        }
                        logger.info("WatchRunner thread exits");
                    }
                }
            }
            catch (KubernetesClientException kce) {
                logger.error("WatchRunner thread failed", (Throwable)kce);
            }
        }

        private boolean isRolloutRequired(OpenShiftClient client, String kieServerId, boolean isDCStable) {
            boolean pullTrigger = false;
            String triggerName = "kieserver-rollout-in-progress-" + kieServerId;
            ConfigMap cm = this.getKieServerCM(client, kieServerId).orElseThrow(IllegalStateException::new);
            Map ann = cm.getMetadata().getAnnotations();
            if (ann != null && ann.containsKey("services.server.kie.org/openshift-startup-strategy.rolloutRequired")) {
                try {
                    if (isDCStable) {
                        client.configMaps().create((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(triggerName)).withLabels(Collections.singletonMap(KIE_SERVER_INSTANCE_ID, kieServerId))).endMetadata()).build()});
                        pullTrigger = true;
                        logger.info("KieServer: {}, DC rollout - Begin", (Object)KIE_SERVER_INSTANCE_ID);
                    } else {
                        logger.info("KieServer: {}, DC rollout - In progress", (Object)KIE_SERVER_INSTANCE_ID);
                    }
                    ann.remove("services.server.kie.org/openshift-startup-strategy.rolloutRequired");
                    client.configMaps().createOrReplace((Object[])new ConfigMap[]{cm});
                }
                catch (KubernetesClientException kce) {
                    logger.debug("Mark DC rollout failed", (Throwable)kce);
                }
            }
            return pullTrigger;
        }
    }
}

