/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.impl.storage.cloud;

import com.thoughtworks.xstream.XStream;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.mockwebserver.Context;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.server.mock.OpenShiftMockServer;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.After;
import org.junit.Before;
import org.kie.server.services.openshift.impl.storage.cloud.CloudClientFactory;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateCloudRepository;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateOpenShiftRepository;

public abstract class KieServerStateOpenShiftRepositoryTest {
    protected static final String KIE_SERVER_STARTUP_IN_PROGRESS_KEY_PREFIX = "org.kie.server.services/";
    protected static final String KIE_SERVER_STARTUP_IN_PROGRESS_VALUE = "kie.server.startup_in_progress";
    protected static final String TEST_KIE_SERVER_ID = "myapp2-kieserver";
    protected static final String TEST_APP_NAME = "myapp2";
    protected static XStream xs = KieServerStateCloudRepository.initializeXStream();
    protected static Supplier<OpenShiftClient> cloudClientHelper = () -> new CloudClientFactory(){}.createOpenShiftClient();
    protected String testNamespace = "test";
    protected OpenShiftClient client;
    protected KieServerStateOpenShiftRepository repo;
    public OpenShiftMockServer server = new OpenShiftMockServer(new Context(), new MockWebServer(), new HashMap(), (Dispatcher)new KubernetesCrudDispatcher(), false);

    @Before
    public void setup() {
        if (System.getenv("KIE_SERVER_ID") != null) {
            System.setProperty("org.kie.server.startup.strategy", "OpenShiftStartupStrategy");
            this.client = cloudClientHelper.get();
        } else {
            this.server.init();
            this.client = this.server.createOpenShiftClient();
        }
        this.repo = new KieServerStateOpenShiftRepository(){

            public OpenShiftClient createOpenShiftClient() {
                return KieServerStateOpenShiftRepositoryTest.this.client;
            }

            public KubernetesClient createKubernetesClient() {
                return KieServerStateOpenShiftRepositoryTest.this.client;
            }

            public boolean isKieServerReady() {
                return true;
            }

            public boolean isDCStable(DeploymentConfig dc) {
                return true;
            }

            public Optional<String> getAppNameFromPod(OpenShiftClient client) {
                return Optional.of(KieServerStateOpenShiftRepositoryTest.TEST_APP_NAME);
            }

            public ConfigMap createOrReplaceCM(OpenShiftClient client, ConfigMap cm) {
                ((NonNamespaceOperation)client.configMaps().inNamespace(KieServerStateOpenShiftRepositoryTest.this.testNamespace)).delete((Object[])new ConfigMap[]{cm});
                return (ConfigMap)((NonNamespaceOperation)client.configMaps().inNamespace(KieServerStateOpenShiftRepositoryTest.this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cm});
            }
        };
        ConfigMap cfm = (ConfigMap)((Resource)this.client.configMaps().load(KieServerStateOpenShiftRepositoryTest.class.getResourceAsStream("/test-kieserver-state-config-map-used.yml"))).get();
        this.repo.createOrReplaceCM(this.client, cfm);
        this.repo.load(TEST_KIE_SERVER_ID);
    }

    @After
    public void tearDown() {
        System.clearProperty("org.kie.server.id");
        System.clearProperty("org.kie.server.location");
        System.clearProperty("org.kie.server.controller.openshift.global.discovery.enabled");
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).delete();
        ((NonNamespaceOperation)this.client.deploymentConfigs().inNamespace(this.testNamespace)).delete();
        this.server.destroy();
        this.client.close();
    }

    protected void createDummyDCandRC() {
        this.createDummyDCandRC(TEST_KIE_SERVER_ID, UUID.randomUUID().toString(), 1);
    }

    protected void createDummyDCandRC(String kieServerID, String kieServerDCUID, int replicas) {
        this.createDummyDCandRC(UUID.randomUUID().toString(), kieServerID, kieServerDCUID, replicas);
    }

    protected void createDummyDCandRC(String name, String kieServerID, String kieServerDCUID, int replicas) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("application", TEST_APP_NAME);
        labels.put("services.server.kie.org/kie-server-id", kieServerID);
        DeploymentConfig dc = ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)((DoneableDeploymentConfig)((NonNamespaceOperation)this.client.deploymentConfigs().inNamespace(this.testNamespace)).createOrReplaceWithNew()).withNewMetadata().withName(name)).withLabels(labels)).withUid(kieServerDCUID)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(replicas))).addNewTrigger().withType("ConfigChange")).endTrigger()).addToSelector("app", "kieserver")).withNewTemplate().withNewMetadata().addToLabels("app", "kieserver")).addToLabels("services.server.kie.org/kie-server-id", kieServerID)).endMetadata()).withNewSpec().addNewContainer().withName("kieserver")).withImage("kieserver")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).done();
        ReplicationController rc = ((DoneableReplicationController)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((DoneableReplicationController)((ReplicationControllerFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)((ObjectMetaFluent.OwnerReferencesNested)((ObjectMetaFluent.OwnerReferencesNested)((ObjectMetaFluent.OwnerReferencesNested)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)((DoneableReplicationController)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.testNamespace)).createOrReplaceWithNew()).withNewMetadata().withName("decoupled-with-kie-server-id")).withUid(kieServerDCUID)).addNewOwnerReference().withApiVersion(dc.getApiVersion())).withKind(dc.getKind())).withName(dc.getMetadata().getName())).withUid(dc.getMetadata().getUid())).endOwnerReference()).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).addToSelector("app", "kieserver")).withNewTemplate().withNewMetadata().addToLabels("app", "kieserver")).addToLabels("services.server.kie.org/kie-server-id", kieServerID)).endMetadata()).withNewSpec().addNewContainer().withName("kieserver")).withImage("kieserver")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).done();
        ((DoneablePod)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DoneablePod)((PodFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)((ObjectMetaFluent.OwnerReferencesNested)((ObjectMetaFluent.OwnerReferencesNested)((ObjectMetaFluent.OwnerReferencesNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((DoneablePod)((NonNamespaceOperation)this.client.pods().inNamespace(this.testNamespace)).createOrReplaceWithNew()).withNewMetadata().withName("decoupled-with-kie-server-id")).addToLabels("app", "kieserver")).addToLabels("services.server.kie.org/kie-server-id", kieServerID)).addNewOwnerReference().withApiVersion(rc.getApiVersion())).withKind(rc.getKind())).withName(rc.getMetadata().getName())).withUid(rc.getMetadata().getUid())).endOwnerReference()).endMetadata()).withNewSpec().addNewContainer().withName("kieserver")).withImage("kieserver")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).done();
    }
}

