/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import org.apache.commons.lang3.StringUtils;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.error.ExecutionErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusExecutionErrorListener
implements ExecutionErrorListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusExecutionErrorListener.class);
    private static final Counter numberOfErrors = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_execution_error_total")).help("Kie Server Execution Errors")).labelNames(new String[]{"deployment_id", "error_type", "activity_name"})).register();

    public void onExecutionError(ExecutionError error) {
        LOGGER.debug("On Execution Error: {}", (Object)error);
        ((Counter.Child)numberOfErrors.labels(new String[]{error.getDeploymentId(), StringUtils.defaultString((String)error.getType()), StringUtils.defaultString((String)error.getActivityName())})).inc();
    }
}

