/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.SwaggerConfigLocator;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentMap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.services.swagger.SwaggerKieServerExtension;

public class SwaggerKierServerExtensionTest {
    @Test
    public void testInit() throws Exception {
        this.resetSwaggerConfig("swagger.config.id.default");
        KieServerEnvironment.setContextRoot((String)"kie-server");
        SwaggerKieServerExtension extension = new SwaggerKieServerExtension();
        extension.init(null, null);
        BeanConfig config = (BeanConfig)SwaggerConfigLocator.getInstance().getConfig("swagger.config.id.default");
        Assert.assertEquals((Object)"/kie-server/services/rest", (Object)config.getBasePath());
    }

    @Test
    public void testInitWithEmptyContextRoot() throws Exception {
        this.resetSwaggerConfig("swagger.config.id.default");
        KieServerEnvironment.setContextRoot((String)"");
        SwaggerKieServerExtension extension = new SwaggerKieServerExtension();
        extension.init(null, null);
        BeanConfig config = (BeanConfig)SwaggerConfigLocator.getInstance().getConfig("swagger.config.id.default");
        Assert.assertEquals((Object)"/services/rest", (Object)config.getBasePath());
    }

    private void resetSwaggerConfig(String configId) throws Exception {
        SwaggerConfigLocator swaggerConfigLocator = SwaggerConfigLocator.getInstance();
        Field configMapField = SwaggerConfigLocator.class.getDeclaredField("configMap");
        configMapField.setAccessible(true);
        ConcurrentMap configMap = (ConcurrentMap)configMapField.get(swaggerConfigLocator);
        configMap.remove("swagger.config.id.default");
    }
}

