/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.swagger;

import io.swagger.config.Scanner;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.DefaultJaxrsScanner;
import io.swagger.jaxrs.config.SwaggerScannerLocator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "Swagger";
    private static final Logger logger = LoggerFactory.getLogger(SwaggerKieServerExtension.class);
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.kie.swagger.server.ext.disabled", "false"));
    private KieServerImpl kieServer;
    private KieServerRegistry context;
    private List<Object> services = new ArrayList<Object>();
    private boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return disabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.kieServer = kieServer;
        this.context = registry;
        DefaultJaxrsScanner jaxrsScanner = new DefaultJaxrsScanner();
        jaxrsScanner.setPrettyPrint(true);
        SwaggerScannerLocator.getInstance().putScanner("swagger.scanner.id.default", (Scanner)jaxrsScanner);
        BeanConfig beanConfig = new BeanConfig();
        String contextRoot = KieServerEnvironment.getContextRoot();
        if (contextRoot != null) {
            beanConfig.setBasePath(contextRoot + "/services/rest");
        }
        beanConfig.setScan(true);
        this.initialized = true;
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.context};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        return null;
    }

    public String getImplementedCapability() {
        return EXTENSION_NAME;
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return "Swagger KIE Server extension";
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        if (report) {
            messages.add(new Message(Severity.INFO, this.getExtensionName() + " is alive"));
        }
        return messages;
    }
}

