/*
 * Decompiled with CFR 0.152.
 */
package org.kie.soup.commons.cron;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.commons.cron.CronExpression;

public class CronExpressionTest {
    private static final String[] VALID_EXPRESSIONS = new String[]{"0 15 10 * * ? 2005", "0 0 0 1 * ?", "19 15 10 4 Apr ?", "0 43 9 ? * 5L", "0 0 0 ? * 4#1 *", "0 0 0 ? * * *", "0 0 12 */7 * ?", "* 0,12 0,13 1W MAY ? *", "0 0 0 ? * WED *", "0 0,1 2-22 1W * ? *", "9/5 0,1 3 LW * ? *", "* 4 3 ? 1 4L *"};
    private static final String[] INVALID_VALID_EXPRESSIONS = new String[]{"* * * * Foo ?", "* * * * Jan-Foo ?", "0 0 * * * *", "0 0 * 4 * *", "0 0 * * * 4", "0 43 9 1,5,29,L * ?", "0 43 9 ? * SAT,SUN,L", "0 43 9 ? * 6,7,L", "0 0 0 L-1 * ? *", "* * 0 *", "0/1 43 9 ? * 6,7,L", "0/a 43 9 ? * 6,7,L", "0 0 12 * * THU", "# # # # # #", "0 0 102 2 * ?", "425 0 1 2 * ?", "0 0 12 */q * ?", "0 0 12 * * THU,WED-SAT"};

    @Test
    public void testCronValidExpression() {
        Arrays.stream(VALID_EXPRESSIONS).forEach(expression -> Assert.assertTrue((boolean)CronExpression.isValidExpression((String)expression)));
    }

    @Test
    public void testCronInvalidExpression() {
        Arrays.stream(INVALID_VALID_EXPRESSIONS).forEach(expression -> Assert.assertFalse((boolean)CronExpression.isValidExpression((String)expression)));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"0 15 10 * * ? 2005", (Object)new CronExpression("0 15 10 * * ? 2005").toString());
    }

    @Test
    public void testGetCronExpression() throws Exception {
        Assert.assertEquals((Object)"0 15 10 * * ? 2005", (Object)new CronExpression("0 15 10 * * ? 2005").getCronExpression());
    }

    @Test
    public void testGetExpressionSummary() throws Exception {
        String value1 = "8 15 10 25 3 ? 2005";
        String expectedSummary1 = "seconds: 8\nminutes: 15\nhours: 10\ndaysOfMonth: 25\nmonths: 3\ndaysOfWeek: ?\nlastdayOfWeek: false\nnearestWeekday: false\nNthDayOfWeek: 0\nlastdayOfMonth: false\nyears: 2005\n";
        Assert.assertEquals((Object)expectedSummary1, (Object)new CronExpression(value1).getExpressionSummary());
        String value2 = "5 10 20 ? * MON,WED 2015";
        String expectedSummary2 = "seconds: 5\nminutes: 10\nhours: 20\ndaysOfMonth: ?\nmonths: *\ndaysOfWeek: 2,4\nlastdayOfWeek: false\nnearestWeekday: false\nNthDayOfWeek: 0\nlastdayOfMonth: false\nyears: 2015\n";
        Assert.assertEquals((Object)expectedSummary2, (Object)new CronExpression(value2).getExpressionSummary());
    }
}

