/*
 * Decompiled with CFR 0.152.
 */
package org.kie.soup.commons.validation;

import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.commons.validation.Preconditions;

public class PreconditionsTest {
    private static final String GREATER_THAN_NOT_MET_ERROR = "Parameter named '%s' must be greater than '%s'!";
    private static final String GREATER_OR_EQUAL_TO_NOT_MET_ERROR = "Parameter named '%s' must be greater or equal to '%s'!";
    private static final String PARAMETER_SHOULD_NOT_BE_NULL_ERROR = "Parameter named '%s' should be not null!";
    private static final String NOT_NULLABLE = "notNullable";
    private static final String NON_NULL_VALUE = "nonNullValue";

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNotEmptyArray() {
        Preconditions.checkNotEmpty((String)"notEmpty", (Object[])new Object[]{1, 2, 3});
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNotEmptyParameter() {
        Preconditions.checkNotEmpty((String)"notEmpty", (String)"notEmpty");
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNotNullParameter() {
        Preconditions.checkNotNull((String)NOT_NULLABLE, (Object)"notNullValue");
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNullParameter() {
        Preconditions.checkNullMandatory((String)"nullable", null);
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingValidConditionParameter() {
        Preconditions.checkCondition((String)"valid", (boolean)true);
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettinOnlyNonNullParameters() {
        Preconditions.checkEachParameterNotNull((String)NOT_NULLABLE, (Object[])new String[]{"nonNull"});
        Preconditions.checkEachParameterNotNull((String)NOT_NULLABLE, (Object[])new String[]{"nonNull", "anotherNonNull"});
    }

    @Test
    public void shouldGetCorrectErrorNessage() {
        try {
            Preconditions.checkNotNull((String)NOT_NULLABLE, null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"Parameter named 'notNullable' should be not null!"));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnCheckEmptyWhenGettingNullParameter() {
        Preconditions.checkNotEmpty((String)"notEmpty", (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettinAllNullParameter() {
        Preconditions.checkEachParameterNotNull((String)NOT_NULLABLE, (Object[])new Object[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingEmptyArray() {
        Preconditions.checkNotEmpty((String)"empty", (Object[])new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingEmptyParameter() {
        Preconditions.checkNotEmpty((String)"notEmpty", (String)"");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionWhenGettingInvalidConditionParameter() {
        Preconditions.checkCondition((String)"valid", (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingNonNullParameter() {
        Preconditions.checkNullMandatory((String)"nullable", (Object)"non null");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingNullArray() {
        Preconditions.checkNotEmpty((String)"empty", (Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingNullParameter() {
        Preconditions.checkNotNull((String)NOT_NULLABLE, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingSpacedParameter() {
        Preconditions.checkNotEmpty((String)"notEmpty", (String)"    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettinOneNullParameter() {
        Preconditions.checkEachParameterNotNull((String)NOT_NULLABLE, (Object[])new String[]{"nonNull", null});
    }

    @Test
    public void checkGreaterThanSuccessful() {
        PortablePreconditions.checkGreaterThan((String)NOT_NULLABLE, (Comparable)Integer.valueOf(1), (Object)0);
    }

    @Test
    public void checkGreaterThanNotMetWhenEqual() {
        this.checkGreaterThanNotMet(Integer.valueOf(1), 1);
    }

    @Test
    public void checkGreaterThanNotMetWhenLower() {
        this.checkGreaterThanNotMet(Integer.valueOf(1), 2);
    }

    private <T> void checkGreaterThanNotMet(Comparable<T> param, T nonNullValue) {
        Assertions.assertThatThrownBy(() -> PortablePreconditions.checkGreaterThan((String)NOT_NULLABLE, (Comparable)param, (Object)nonNullValue)).hasMessageStartingWith(String.format(GREATER_THAN_NOT_MET_ERROR, NOT_NULLABLE, nonNullValue));
    }

    @Test
    public void checkGreaterThanWhenNullParam() {
        Assertions.assertThatThrownBy(() -> PortablePreconditions.checkGreaterThan((String)NOT_NULLABLE, null, (Object)1)).hasMessageStartingWith(String.format(PARAMETER_SHOULD_NOT_BE_NULL_ERROR, NOT_NULLABLE));
    }

    @Test
    public void checkGreaterThanWhenNullValueParam() {
        Assertions.assertThatThrownBy(() -> PortablePreconditions.checkGreaterThan((String)NOT_NULLABLE, (Comparable)Integer.valueOf(1), null)).hasMessageStartingWith(String.format(PARAMETER_SHOULD_NOT_BE_NULL_ERROR, NON_NULL_VALUE));
    }

    @Test
    public void checkGreaterOrEqualToWhenEqualSuccessful() {
        PortablePreconditions.checkGreaterOrEqualTo((String)NOT_NULLABLE, (Comparable)Integer.valueOf(1), (Object)1);
    }

    @Test
    public void checkGreaterOrEqualToWhenGreaterSuccessful() {
        PortablePreconditions.checkGreaterOrEqualTo((String)NOT_NULLABLE, (Comparable)Integer.valueOf(1), (Object)0);
    }

    @Test
    public void checkGreaterOrEqualToNotMet() {
        Assertions.assertThatThrownBy(() -> PortablePreconditions.checkGreaterOrEqualTo((String)NOT_NULLABLE, (Comparable)Integer.valueOf(0), (Object)1)).hasMessageStartingWith(String.format(GREATER_OR_EQUAL_TO_NOT_MET_ERROR, NOT_NULLABLE, 1));
    }

    @Test
    public void checkGreaterOrEqualToWhenNullParam() {
        Assertions.assertThatThrownBy(() -> PortablePreconditions.checkGreaterOrEqualTo((String)NOT_NULLABLE, null, (Object)1)).hasMessageStartingWith(String.format(PARAMETER_SHOULD_NOT_BE_NULL_ERROR, NOT_NULLABLE));
    }

    @Test
    public void checkGreaterOrEqualToWhenNullValueParam() {
        Assertions.assertThatThrownBy(() -> PortablePreconditions.checkGreaterOrEqualTo((String)NOT_NULLABLE, (Comparable)Integer.valueOf(1), null)).hasMessageStartingWith(String.format(PARAMETER_SHOULD_NOT_BE_NULL_ERROR, NON_NULL_VALUE));
    }
}

