/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.csv;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataprovider.csv.CSVFileStorage;
import org.dashbuilder.dataprovider.csv.CSVParser;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVDataSetProvider
implements DataSetProvider,
DataSetDefRegistryListener {
    protected StaticDataSetProvider staticDataSetProvider;
    protected CSVFileStorage csvStorage;
    protected Logger log = LoggerFactory.getLogger(CSVDataSetProvider.class);
    private static CSVDataSetProvider SINGLETON = null;

    public static CSVDataSetProvider get() {
        if (SINGLETON == null) {
            StaticDataSetProvider staticDataSetProvider = DataSetCore.get().getStaticDataSetProvider();
            DataSetDefRegistry dataSetDefRegistry = DataSetCore.get().getDataSetDefRegistry();
            SINGLETON = new CSVDataSetProvider(staticDataSetProvider, null);
            dataSetDefRegistry.addListener((DataSetDefRegistryListener)SINGLETON);
        }
        return SINGLETON;
    }

    public CSVDataSetProvider() {
    }

    public CSVDataSetProvider(StaticDataSetProvider staticDataSetProvider, CSVFileStorage csvStorage) {
        this.staticDataSetProvider = staticDataSetProvider;
        this.csvStorage = csvStorage;
    }

    public DataSetProviderType getType() {
        return DataSetProviderType.CSV;
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        DataSet dataSet = this.lookupDataSet(def, null);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def.getUUID(), null);
        CSVDataSetDef csvDef = (CSVDataSetDef)def;
        if (lookup != null && lookup.testMode() || dataSet == null || this.hasCSVFileChanged(dataSet, csvDef)) {
            CSVParser csvParser = new CSVParser(csvDef, this.csvStorage);
            dataSet = csvParser.load();
            dataSet.setUUID(def.getUUID());
            dataSet.setDefinition(def);
            this.staticDataSetProvider.registerDataSet(dataSet);
        }
        try {
            dataSet = this.staticDataSetProvider.lookupDataSet(def, lookup);
        }
        finally {
            if (lookup != null && lookup.testMode()) {
                this.staticDataSetProvider.removeDataSet(def.getUUID());
            }
        }
        return dataSet;
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def, null);
        if (dataSet == null) {
            return false;
        }
        return this.hasCSVFileChanged(dataSet, (CSVDataSetDef)def);
    }

    protected boolean hasCSVFileChanged(DataSet dataSet, CSVDataSetDef def) {
        if (StringUtils.isBlank((CharSequence)def.getFilePath())) {
            return false;
        }
        File f = new File(def.getFilePath());
        return f.exists() && f.lastModified() > dataSet.getCreationDate().getTime();
    }

    public void onDataSetDefStale(DataSetDef def) {
        this.staticDataSetProvider.removeDataSet(def.getUUID());
    }

    public void onDataSetDefModified(DataSetDef olDef, DataSetDef newDef) {
        this.staticDataSetProvider.removeDataSet(olDef.getUUID());
    }

    public void onDataSetDefRemoved(DataSetDef oldDef) {
        this.staticDataSetProvider.removeDataSet(oldDef.getUUID());
    }

    public void onDataSetDefRegistered(DataSetDef newDef) {
    }
}

