/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.csv;

import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.csv.CSVDataSetProvider;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.fest.assertions.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class CSVDataSetDefJSONTest {
    DataSetDefJSONMarshaller jsonMarshaller;
    DataSetManager dataSetManager;
    DataSetProviderRegistry dataSetProviderRegistry;

    @Before
    public void setUp() {
        this.dataSetProviderRegistry = DataSetCore.get().getDataSetProviderRegistry();
        this.dataSetProviderRegistry.registerDataProvider((DataSetProvider)CSVDataSetProvider.get());
        this.jsonMarshaller = DataSetCore.get().getDataSetDefJSONMarshaller();
        this.dataSetManager = DataSetCore.get().getDataSetManager();
    }

    @Test
    public void testParseCSVJson() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports.dset");
        String json = IOUtils.toString((URL)fileURL);
        DataSetDef def = this.jsonMarshaller.fromJson(json);
        Assertions.assertThat((Object)def.getProvider()).isEqualTo((Object)DataSetProviderType.CSV);
        Assertions.assertThat((boolean)def.isPublic()).isEqualTo(true);
        Assertions.assertThat((boolean)def.isPushEnabled()).isEqualTo(true);
        Assertions.assertThat((Integer)def.getPushMaxSize()).isEqualTo(1024);
        CSVDataSetDef csvDef = (CSVDataSetDef)def;
        Assertions.assertThat((Character)csvDef.getSeparatorChar()).isEqualTo(';');
        Assertions.assertThat((Character)csvDef.getEscapeChar()).isEqualTo('\\');
        Assertions.assertThat((Character)csvDef.getQuoteChar()).isEqualTo('\"');
        Assertions.assertThat((String)csvDef.getDatePattern()).isEqualTo((Object)"MM-dd-yyyy");
        Assertions.assertThat((String)csvDef.getNumberPattern()).isEqualTo((Object)"#,###.##");
        Assertions.assertThat((String)csvDef.getPattern("date")).isEqualTo((Object)"MM-dd-yyyy");
        Assertions.assertThat((String)csvDef.getPattern("amount")).isEqualTo((Object)"#,###.##");
        Assertions.assertThat((Object)csvDef.getColumnById("id").getColumnType()).isEqualTo((Object)ColumnType.LABEL);
        Assertions.assertThat((Object)csvDef.getColumnById("amount").getColumnType()).isEqualTo((Object)ColumnType.NUMBER);
        Assertions.assertThat((Object)csvDef.getColumnById("date").getColumnType()).isEqualTo((Object)ColumnType.DATE);
    }
}

