/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import java.util.ArrayList;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetTestBase;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElasticSearchMultiFieldsTest
extends ElasticSearchDataSetTestBase {
    protected static final String EL_MULTIFIELDS_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/multifields.dset";
    protected static final String EL__MULTIFIELDS_UUID = "multifields";

    @Before
    public void registerDataSet() throws Exception {
        super.setUp();
        this._registerDataSet(EL_MULTIFIELDS_DEF);
    }

    @Test
    public void testColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(EL__MULTIFIELDS_UUID)).sort("FIELD2.RAW", SortOrder.DESCENDING)).buildLookup());
        Assert.assertNotNull((Object)result.getColumns());
        Assert.assertTrue((result.getColumns().size() == 5 ? 1 : 0) != 0);
        ArrayList<DataColumnImpl> expected = new ArrayList<DataColumnImpl>(5);
        DataColumnImpl colField2 = new DataColumnImpl("FIELD2", ColumnType.TEXT);
        expected.add(colField2);
        DataColumnImpl colDate = new DataColumnImpl("DATE", ColumnType.DATE);
        expected.add(colDate);
        DataColumnImpl colField2Raw = new DataColumnImpl("FIELD2.RAW", ColumnType.LABEL);
        expected.add(colField2Raw);
        DataColumnImpl colNumber = new DataColumnImpl("NUMBER", ColumnType.NUMBER);
        expected.add(colNumber);
        DataColumnImpl colField1 = new DataColumnImpl("FIELD1", ColumnType.TEXT);
        expected.add(colField1);
        Assert.assertTrue((result.getColumns().size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.getColumns().contains(colField1));
        Assert.assertTrue((boolean)result.getColumns().contains(colField2));
        Assert.assertTrue((boolean)result.getColumns().contains(colField2Raw));
        Assert.assertTrue((boolean)result.getColumns().contains(colDate));
        Assert.assertTrue((boolean)result.getColumns().contains(colNumber));
    }
}

