/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetProvider;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchDataSetTestBase {
    static final Logger logger = LoggerFactory.getLogger(ElasticSearchDataSetTestBase.class);
    public static final String EL_EXAMPLE_INDEX = "expensereports";
    public static final String EL_EXAMPLE_TYPE = "expense";
    public static final String EL_EXAMPLE_DEPT_ENGINEERING = "Engineering";
    public static final String EL_EXAMPLE_DEPT_SERVICES = "Services";
    public static final String EL_EXAMPLE_DEPT_MANAGEMENT = "Management";
    public static final String EL_EXAMPLE_DEPT_SALES = "Sales";
    public static final String EL_EXAMPLE_DEPT_SUPPORT = "Support";
    public static final String EL_EXAMPLE_CITY_BARCELONA = "Barcelona";
    public static final String EL_EXAMPLE_CITY_MADRID = "Madrid";
    public static final String EL_EXAMPLE_CITY_RALEIGH = "Raleigh";
    public static final String EL_EXAMPLE_CITY_LONDON = "London";
    public static final String EL_EXAMPLE_EMP_ROXIE = "Roxie Foraker";
    public static final String EL_EXAMPLE_EMP_JAMIE = "Jamie Gilbeau";
    public static final String EL_EXAMPLE_EMP_NITA = "Nita Marling";
    public static final String EL_EXAMPLE_EMP_HANNA = "Hannah B. Mackey";
    public static final String EL_EXAMPLE_EMP_PATRICIA = "Patricia J. Behr";
    protected DataSetManager dataSetManager;
    protected DataSetDefRegistry dataSetDefRegistry;
    protected DataSetDefJSONMarshaller jsonMarshaller;
    protected DataSetFormatter dataSetFormatter;

    @Before
    public void setUp() throws Exception {
        this.dataSetManager = DataSetCore.get().getDataSetManager();
        this.dataSetDefRegistry = DataSetCore.get().getDataSetDefRegistry();
        this.jsonMarshaller = DataSetCore.get().getDataSetDefJSONMarshaller();
        this.dataSetFormatter = new DataSetFormatter();
        DataSetProviderRegistry dataSetProviderRegistry = DataSetCore.get().getDataSetProviderRegistry();
        dataSetProviderRegistry.registerDataProvider((DataSetProvider)ElasticSearchDataSetProvider.get());
    }

    protected ElasticSearchDataSetDef _registerDataSet(String resource) throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource(resource);
        String json = IOUtils.toString((URL)fileURL, (Charset)StandardCharsets.UTF_8);
        ElasticSearchDataSetDef def = (ElasticSearchDataSetDef)this.jsonMarshaller.fromJson(json);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        return def;
    }

    protected static void log(Object message) {
        System.out.print(message);
        if (logger.isDebugEnabled()) {
            logger.debug(message.toString());
        }
    }

    protected void printDataSet(DataSet dataSet) {
        ElasticSearchDataSetTestBase.log(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

