/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl;

import java.net.InetAddress;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class NativeClientFactory {
    private static final NativeClientFactory INSTANCE = new NativeClientFactory();
    protected static final String EL_CLUTER_NAME = "cluster.name";
    protected static final String EL_CLIENT_TIMEOUT = "client.transport.ping_timeout";
    protected static final String EL_SECURITY = "transport.type";
    private Client testClient;

    public static NativeClientFactory getInstance() {
        return INSTANCE;
    }

    public void setTestClient(Client c) {
        this.testClient = c;
    }

    public Client newClient(String serverURL, String clusterName, long timeout) throws Exception {
        if (null != this.testClient) {
            return this.testClient;
        }
        if (null == clusterName || clusterName.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter clusterName is missing.");
        }
        if (null == serverURL || serverURL.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter serverURL is missing.");
        }
        String[] url = serverURL.split(":");
        if (url.length != 2) {
            throw new IllegalArgumentException("Invalid serverURL format. Expected format <HOST>:<PORT>");
        }
        String t = timeout / 1000L + "s";
        Settings settings = Settings.builder().put(EL_CLUTER_NAME, clusterName).put(EL_CLIENT_TIMEOUT, t).put(EL_SECURITY, "netty4").build();
        return new PreBuiltTransportClient(settings, new Class[0]).addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(url[0]), Integer.parseInt(url[1])));
    }
}

