/*
 * Copyright 2014 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.model;

public class FieldMappingResponse {

    public static enum FieldType {
        TEXT,
        FLOAT,
        DOUBLE,
        BYTE,
        SHORT,
        INTEGER,
        LONG,
        TOKEN_COUNT,
        DATE,
        BOOLEAN,
        BINARY,
        KEYWORD
    }

    public static enum IndexType {
        ANALYZED,
        NOT_ANALYZED,
        NO
    }

    private final String name;
    private final FieldType dataType;
    private final String format;
    private final IndexType indexType;
    private final MultiFieldMappingResponse[] multiFields;

    public FieldMappingResponse(String name,
                                FieldType dataType,
                                IndexType indexType) {
        this.name = name;
        this.dataType = dataType;
        this.indexType = indexType;
        this.format = null;
        this.multiFields = null;
    }

    public FieldMappingResponse(String name,
                                FieldType dataType,
                                IndexType indexType,
                                String format) {
        this.name = name;
        this.dataType = dataType;
        this.indexType = indexType;
        this.format = format;
        this.multiFields = null;
    }

    public FieldMappingResponse(String name,
                                FieldType dataType,
                                IndexType indexType,
                                String format,
                                MultiFieldMappingResponse[] multiFields) {
        this.name = name;
        this.dataType = dataType;
        this.indexType = indexType;
        this.format = format;
        this.multiFields = multiFields;
    }

    public String getName() {
        return name;
    }

    public FieldType getDataType() {
        return dataType;
    }

    public IndexType getIndexType() {
        return indexType;
    }

    public String getFormat() {
        return format;
    }

    public MultiFieldMappingResponse[] getMultiFields() {
        return multiFields;
    }
}
