/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchClientFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.ElasticSearchClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.exception.ElasticSearchClientGenericException;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchRequest;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.IntervalBuilderDynamicDate;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalPattern;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.min.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public class NativeClientAggregationsBuilder {
    private final ElasticSearchClientFactory clientFactory;
    private final IntervalBuilderDynamicDate intervalBuilder;
    private final ElasticSearchUtils utils;
    private final DataSetMetadata metadata;
    private final List<DataColumn> columns;
    private final SearchRequest request;

    public NativeClientAggregationsBuilder(ElasticSearchClientFactory clientFactory, IntervalBuilderDynamicDate intervalBuilder, ElasticSearchUtils utils, DataSetMetadata metadata, List<DataColumn> columns, SearchRequest request) {
        this.clientFactory = clientFactory;
        this.intervalBuilder = intervalBuilder;
        this.utils = utils;
        this.metadata = metadata;
        this.columns = columns;
        this.request = request;
    }

    public List<AbstractAggregationBuilder> build(DataSetGroup groupOp) throws ElasticSearchClientGenericException {
        AbstractAggregationBuilder b;
        ColumnGroup columnGroup = groupOp.getColumnGroup();
        List groupFunctions = groupOp.getGroupFunctions();
        LinkedList<GroupFunction> columnPickUps = new LinkedList<GroupFunction>();
        LinkedList<AbstractAggregationBuilder> aggregationBuilders = new LinkedList<AbstractAggregationBuilder>();
        if (groupFunctions != null && !groupFunctions.isEmpty()) {
            for (GroupFunction groupFunction : groupFunctions) {
                if (groupFunction.getFunction() != null) {
                    b = this.serializeCoreFunction(groupFunction);
                    if (null == b) continue;
                    aggregationBuilders.add(b);
                    continue;
                }
                columnPickUps.add(groupFunction);
            }
        }
        if (columnGroup != null) {
            String columnId = columnGroup.getColumnId();
            String sourceId = columnGroup.getSourceId();
            if (!columnPickUps.isEmpty()) {
                b = columnPickUps.iterator();
                while (b.hasNext()) {
                    GroupFunction groupFunction = (GroupFunction)b.next();
                    if (groupFunction.getFunction() != null || !sourceId.equals(groupFunction.getSourceId())) continue;
                    columnId = groupFunction.getColumnId();
                    if (this.existColumnInMetadataDef(sourceId)) continue;
                    throw new RuntimeException("Aggregation by column [" + sourceId + "] failed. No column with the given id.");
                }
            }
            if (null != (b = this.serializeGroupByFunction(columnGroup, columnId, aggregationBuilders))) {
                return new ArrayList<AbstractAggregationBuilder>(){
                    {
                        this.add(b);
                    }
                };
            }
        } else if (!columnPickUps.isEmpty()) {
            throw new RuntimeException("Column [" + ((GroupFunction)columnPickUps.get(0)).getSourceId() + "] pickup  failed. No grouping is set for this column.");
        }
        return aggregationBuilders;
    }

    protected ValuesSourceAggregationBuilder serializeCoreFunction(GroupFunction groupFunction) {
        if (null != groupFunction) {
            String sourceId = groupFunction.getSourceId();
            if (sourceId != null && !this.existColumnInMetadataDef(sourceId)) {
                throw new RuntimeException("Aggregation by column [" + sourceId + "] failed. No column with the given id.");
            }
            if (sourceId == null) {
                sourceId = this.metadata.getColumnId(0);
            }
            if (sourceId == null) {
                throw new IllegalArgumentException("Aggregation from unknown column id.");
            }
            String columnId = groupFunction.getColumnId();
            if (columnId == null) {
                columnId = sourceId;
            }
            AggregateFunctionType type = groupFunction.getFunction();
            ColumnType sourceColumnType = this.metadata.getColumnType(sourceId);
            ValuesSourceAggregationBuilder result = null;
            switch (type) {
                case COUNT: {
                    result = AggregationBuilders.count((String)columnId).field(sourceId);
                    break;
                }
                case DISTINCT: {
                    result = AggregationBuilders.cardinality((String)columnId).field(sourceId);
                    break;
                }
                case AVERAGE: {
                    result = AggregationBuilders.avg((String)columnId).field(sourceId);
                    break;
                }
                case SUM: {
                    result = AggregationBuilders.sum((String)columnId).field(sourceId);
                    break;
                }
                case MIN: {
                    result = AggregationBuilders.min((String)columnId).field(sourceId);
                    break;
                }
                case MAX: {
                    result = AggregationBuilders.max((String)columnId).field(sourceId);
                }
            }
            if (null == result) {
                throw new RuntimeException("Core function not supported as an Elastic Search aggregation [type=" + type.name() + "]");
            }
            return result;
        }
        return null;
    }

    protected AbstractAggregationBuilder serializeGroupByFunction(ColumnGroup columnGroup, String resultingColumnId, List<AbstractAggregationBuilder> aggregationBuilders) throws ElasticSearchClientGenericException {
        if (columnGroup == null || this.metadata == null) {
            return null;
        }
        String sourceId = columnGroup.getSourceId();
        if (resultingColumnId == null) {
            resultingColumnId = sourceId;
        }
        boolean asc = columnGroup.isAscendingOrder();
        ColumnType columnType = this.metadata.getColumnType(sourceId);
        GroupStrategy groupStrategy = columnGroup.getStrategy();
        String intervalSize = columnGroup.getIntervalSize();
        boolean areEmptyIntervalsAllowed = columnGroup.areEmptyIntervalsAllowed();
        int minDocCount = areEmptyIntervalsAllowed ? 0 : 1;
        int maxIntervals = columnGroup.getMaxIntervals();
        TermsAggregationBuilder theResult = null;
        if (ColumnType.LABEL.equals((Object)columnType)) {
            TermsAggregationBuilder termsBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)resultingColumnId).field(sourceId)).size(10000).minDocCount((long)minDocCount).order(Terms.Order.term((boolean)asc));
            this.addSubAggregations((AggregationBuilder)termsBuilder, aggregationBuilders);
            if (this.columns != null) {
                DataColumn column = this.getColumn(resultingColumnId);
                column.setColumnGroup(new ColumnGroup(sourceId, resultingColumnId, columnGroup.getStrategy(), columnGroup.getMaxIntervals(), columnGroup.getIntervalSize()));
            }
            theResult = termsBuilder;
        } else if (ColumnType.NUMBER.equals((Object)columnType)) {
            HistogramAggregationBuilder histogramBuilder = ((HistogramAggregationBuilder)new HistogramAggregationBuilder(resultingColumnId).field(sourceId)).minDocCount((long)minDocCount).order(asc ? Histogram.Order.KEY_ASC : Histogram.Order.KEY_DESC);
            if (null != intervalSize) {
                histogramBuilder.interval((double)Long.parseLong(intervalSize));
            }
            this.addSubAggregations((AggregationBuilder)histogramBuilder, aggregationBuilders);
            if (this.columns != null) {
                DataColumn column = this.getColumn(resultingColumnId);
                column.setColumnGroup(new ColumnGroup(sourceId, resultingColumnId, columnGroup.getStrategy(), columnGroup.getMaxIntervals(), columnGroup.getIntervalSize()));
            }
            theResult = histogramBuilder;
        } else if (ColumnType.DATE.equals((Object)columnType)) {
            DateIntervalType dateIntervalType = null;
            if (GroupStrategy.FIXED.equals((Object)columnGroup.getStrategy())) {
                if (intervalSize != null) {
                    dateIntervalType = DateIntervalType.valueOf((String)intervalSize);
                }
                if (dateIntervalType == null) {
                    throw new RuntimeException("Column [" + columnGroup.getColumnId() + "] is type Date and grouped using a fixed strategy, but the ate interval type is not specified. Please specify it.");
                }
                String[] scripts = this.buildIntervalExtractorScript(sourceId, columnGroup);
                String valueScript = scripts[0];
                String orderScript = scripts[1];
                TermsAggregationBuilder termsBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)resultingColumnId).size(10000).minDocCount((long)minDocCount).script(new Script(valueScript));
                if (null == orderScript) {
                    termsBuilder.order(Terms.Order.term((boolean)asc));
                } else {
                    termsBuilder.order(Terms.Order.aggregation((String)"_sortOrder", (boolean)true));
                }
                this.addSubAggregations((AggregationBuilder)termsBuilder, aggregationBuilders);
                if (null != orderScript) {
                    MinAggregationBuilder orderAggBuilder = AggregationBuilders.min((String)"_sortOrder");
                    orderAggBuilder.script(new Script(orderScript));
                    termsBuilder.subAggregation((AggregationBuilder)orderAggBuilder);
                }
                theResult = termsBuilder;
            }
            if (GroupStrategy.DYNAMIC.equals((Object)columnGroup.getStrategy())) {
                if (intervalSize != null) {
                    dateIntervalType = DateIntervalType.valueOf((String)intervalSize);
                } else {
                    try {
                        ElasticSearchClient anotherClient = this.clientFactory.newClient((ElasticSearchDataSetDef)this.metadata.getDefinition());
                        Date[] limits = this.utils.calculateDateLimits(anotherClient, this.metadata, columnGroup.getSourceId(), this.request != null ? this.request.getQuery() : null);
                        if (limits != null) {
                            dateIntervalType = this.intervalBuilder.calculateIntervalSize(limits[0], limits[1], columnGroup);
                        }
                        anotherClient.close();
                    }
                    catch (Exception e) {
                        throw new ElasticSearchClientGenericException("Cannot calculate date limits.", e);
                    }
                }
                if (dateIntervalType == null) {
                    dateIntervalType = DateIntervalType.MILLISECOND;
                }
                String intervalPattern = DateIntervalPattern.getPattern((DateIntervalType)dateIntervalType);
                DateHistogramAggregationBuilder builder = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)resultingColumnId).field(sourceId)).dateHistogramInterval(this.getInterval(dateIntervalType)).format(intervalPattern)).minDocCount((long)minDocCount).order(asc ? Histogram.Order.KEY_ASC : Histogram.Order.KEY_DESC);
                this.addSubAggregations((AggregationBuilder)builder, aggregationBuilders);
                theResult = builder;
            }
            if (this.columns != null) {
                DataColumn column = this.getColumn(resultingColumnId);
                column.setColumnType(ColumnType.LABEL);
                column.setIntervalType(dateIntervalType.name());
                ColumnGroup cg = new ColumnGroup(sourceId, resultingColumnId, columnGroup.getStrategy(), columnGroup.getMaxIntervals(), columnGroup.getIntervalSize());
                cg.setEmptyIntervalsAllowed(areEmptyIntervalsAllowed);
                cg.setFirstMonthOfYear(columnGroup.getFirstMonthOfYear());
                cg.setFirstDayOfWeek(columnGroup.getFirstDayOfWeek());
                column.setColumnGroup(cg);
            }
        } else {
            throw new RuntimeException("No translation supported for column group with sourceId [" + sourceId + "] and group strategy [" + groupStrategy.name() + "].");
        }
        return theResult;
    }

    private void addSubAggregations(AggregationBuilder parent, List<AbstractAggregationBuilder> aggregationBuilders) {
        if (null != aggregationBuilders && !aggregationBuilders.isEmpty()) {
            for (AbstractAggregationBuilder b : aggregationBuilders) {
                parent.subAggregation((AggregationBuilder)b);
            }
        }
    }

    protected DateHistogramInterval getInterval(DateIntervalType dateIntervalType) {
        String intervalExpression;
        switch (dateIntervalType) {
            case MILLISECOND: {
                intervalExpression = "0.001s";
                break;
            }
            case HUNDRETH: {
                intervalExpression = "0.01s";
                break;
            }
            case TENTH: {
                intervalExpression = "0.1s";
                break;
            }
            case SECOND: {
                intervalExpression = "1s";
                break;
            }
            case MINUTE: {
                intervalExpression = "1m";
                break;
            }
            case HOUR: {
                intervalExpression = "1h";
                break;
            }
            case DAY: {
                intervalExpression = "1d";
                break;
            }
            case DAY_OF_WEEK: {
                intervalExpression = "1d";
                break;
            }
            case WEEK: {
                intervalExpression = "1w";
                break;
            }
            case MONTH: {
                intervalExpression = "1M";
                break;
            }
            case QUARTER: {
                intervalExpression = "1q";
                break;
            }
            case YEAR: {
                intervalExpression = "1y";
                break;
            }
            case DECADE: {
                intervalExpression = "10y";
                break;
            }
            case CENTURY: {
                intervalExpression = "100y";
                break;
            }
            case MILLENIUM: {
                intervalExpression = "1000y";
                break;
            }
            default: {
                throw new RuntimeException("No interval mapping for date interval type [" + dateIntervalType.name() + "].");
            }
        }
        return new DateHistogramInterval(intervalExpression);
    }

    private String[] buildIntervalExtractorScript(String sourceId, ColumnGroup columnGroup) {
        int[] positions;
        DateIntervalType intervalType = DateIntervalType.getByName((String)columnGroup.getIntervalSize());
        Month firstMonth = columnGroup.getFirstMonthOfYear();
        DayOfWeek firstDayOfWeek = columnGroup.getFirstDayOfWeek();
        String script = "Instant.ofEpochMilli(new Date(doc[\"{0}\"].value).getTime()).atZone(ZoneId.systemDefault()).toLocalDate().";
        switch (intervalType) {
            case QUARTER: {
                script = "Math.ceil((" + script + "getMonth().getValue()-1) / 3 ).intValue()+1";
                break;
            }
            case MONTH: {
                script = script + "getMonth().getValue()";
                break;
            }
            case DAY_OF_WEEK: {
                script = script + "getDayOfWeek().plus(1).getValue()";
                break;
            }
            case HOUR: {
                script = script + "getHour()";
                break;
            }
            case MINUTE: {
                script = script + "getMinute()";
                break;
            }
            case SECOND: {
                script = script + "getSecond()";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Fixed grouping strategy by interval type " + intervalType.name() + " is not supported.");
            }
        }
        String valueScript = MessageFormat.format(script, sourceId);
        String orderScript = null;
        if (firstMonth != null && intervalType.equals((Object)DateIntervalType.MONTH)) {
            int firstMonthIndex = firstMonth.getIndex();
            positions = this.buildPositionsArray(firstMonthIndex, 12, columnGroup.isAscendingOrder());
            orderScript = "int month=" + valueScript + "; List list = " + Arrays.toString(positions) + "; list.indexOf(month)";
        }
        if (firstDayOfWeek != null && intervalType.equals((Object)DateIntervalType.DAY_OF_WEEK)) {
            int firstDayIndex = firstDayOfWeek.getIndex();
            positions = this.buildPositionsArray(firstDayIndex, 7, columnGroup.isAscendingOrder());
            orderScript = "int day=" + valueScript + "; List list = " + Arrays.toString(positions) + "; list.indexOf(day)";
        }
        return new String[]{valueScript, orderScript};
    }

    private int[] buildPositionsArray(int firstElementIndex, int end, boolean asc) {
        int[] positions = new int[end];
        int month = firstElementIndex;
        for (int x = 0; x < end; ++x) {
            if (month > end) {
                month = 1;
            }
            if (month < 1) {
                month = end;
            }
            positions[x] = month++;
            if (asc) continue;
            --month;
        }
        return positions;
    }

    protected boolean existColumnInMetadataDef(String name) {
        if (name == null || this.metadata == null) {
            return false;
        }
        int cols = this.metadata.getNumberOfColumns();
        for (int x = 0; x < cols; ++x) {
            String colName = this.metadata.getColumnId(x);
            if (!name.equals(colName)) continue;
            return true;
        }
        return false;
    }

    protected DataColumn getColumn(String columnId) {
        if (this.columns != null && columnId != null && !this.columns.isEmpty()) {
            for (DataColumn column : this.columns) {
                if (!columnId.equals(column.getId())) continue;
                return column;
            }
        }
        return null;
    }
}

