/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetTestBase;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.fest.assertions.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElasticSearchDataSetTest
extends ElasticSearchDataSetTestBase {
    protected static final String EL_EXAMPLE_DATASET_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/expensereports.dset";
    protected static final String EL_EXAMPLE_CSENSITIVE_DATASET_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/expensereports-csensitive.dset";
    protected static final String EL_DATASET_UUID = "expense_reports";
    protected static final String EL_DATASET_CSENSITIVE_UUID = "expense_reports_csensitive";
    private static final String DATE_FORMAT = "yyyy-MM-dd Z";

    @Before
    public void registerDataSet() throws Exception {
        super.setUp();
        this._registerDataSet(EL_EXAMPLE_DATASET_DEF);
        this._registerDataSet(EL_EXAMPLE_CSENSITIVE_DATASET_DEF);
    }

    @Test
    public void testColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assert.assertNotNull((Object)result.getColumns());
        Assert.assertTrue((result.getColumns().size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.getColumnByIndex(0).getId().equals("EXPENSES_ID"));
        Assert.assertTrue((boolean)result.getColumnByIndex(1).getId().equals("AMOUNT"));
        Assert.assertTrue((boolean)result.getColumnByIndex(2).getId().equals("DEPARTMENT"));
        Assert.assertTrue((boolean)result.getColumnByIndex(3).getId().equals("EMPLOYEE"));
        Assert.assertTrue((boolean)result.getColumnByIndex(4).getId().equals("CREATION_DATE"));
        Assert.assertTrue((boolean)result.getColumnByIndex(5).getId().equals("CITY"));
        Assert.assertTrue((boolean)result.getColumnByIndex(0).getColumnType().equals((Object)ColumnType.NUMBER));
        Assert.assertTrue((boolean)result.getColumnByIndex(1).getColumnType().equals((Object)ColumnType.NUMBER));
        Assert.assertTrue((boolean)result.getColumnByIndex(2).getColumnType().equals((Object)ColumnType.LABEL));
        Assert.assertTrue((boolean)result.getColumnByIndex(3).getColumnType().equals((Object)ColumnType.TEXT));
        Assert.assertTrue((boolean)result.getColumnByIndex(4).getColumnType().equals((Object)ColumnType.DATE));
        Assert.assertTrue((boolean)result.getColumnByIndex(5).getColumnType().equals((Object)ColumnType.LABEL));
    }

    @Test
    public void testBasicLookup() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(50);
    }

    @Test
    public void testDefaultLookup() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(50);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)result.getValueAt(49, 0)).isEqualTo((Object)50.0);
        Assertions.assertThat((Object)result.getValueAt(0, 1)).isEqualTo((Object)120.35);
        Assertions.assertThat((Object)result.getValueAt(0, 2)).isEqualTo((Object)"Engineering");
        Assertions.assertThat((Object)result.getValueAt(0, 3)).isEqualTo((Object)"Roxie Foraker");
        Date date = new SimpleDateFormat(DATE_FORMAT).parse("2015-12-11 -0900");
        Assertions.assertThat((Object)result.getValueAt(0, 4)).isEqualTo((Object)date);
        Assertions.assertThat((Object)result.getValueAt(0, 5)).isEqualTo((Object)"Barcelona");
        Assertions.assertThat((Object)result.getValueAt(1, 0)).isEqualTo((Object)2.0);
        Assertions.assertThat((Object)result.getValueAt(1, 1)).isEqualTo((Object)1100.1);
        Assertions.assertThat((Object)result.getValueAt(1, 2)).isEqualTo((Object)"Engineering");
        Assertions.assertThat((Object)result.getValueAt(1, 3)).isEqualTo((Object)"Roxie Foraker");
        date = new SimpleDateFormat(DATE_FORMAT).parse("2015-12-01 -0900");
        Assertions.assertThat((Object)result.getValueAt(1, 4)).isEqualTo((Object)date);
        Assertions.assertThat((Object)result.getValueAt(1, 5)).isEqualTo((Object)"Barcelona");
        Assertions.assertThat((Object)result.getValueAt(8, 0)).isEqualTo((Object)9.0);
        Assertions.assertThat((Object)result.getValueAt(8, 1)).isEqualTo((Object)75.75);
        Assertions.assertThat((Object)result.getValueAt(8, 2)).isEqualTo((Object)"Sales");
        Assertions.assertThat((Object)result.getValueAt(8, 3)).isEqualTo((Object)"Nita Marling");
        date = new SimpleDateFormat(DATE_FORMAT).parse("2015-05-11 -0900");
        Assertions.assertThat((Object)result.getValueAt(8, 4)).isEqualTo((Object)date);
        Assertions.assertThat((Object)result.getValueAt(8, 5)).isEqualTo((Object)"Madrid");
        Assertions.assertThat((Object)result.getValueAt(30, 0)).isEqualTo((Object)31.0);
        Assertions.assertThat((Object)result.getValueAt(30, 1)).isEqualTo((Object)234.34);
        Assertions.assertThat((Object)result.getValueAt(30, 2)).isEqualTo((Object)"Management");
        Assertions.assertThat((Object)result.getValueAt(30, 3)).isEqualTo((Object)"Hannah B. Mackey");
        date = new SimpleDateFormat(DATE_FORMAT).parse("2013-09-01 -0900");
        Assertions.assertThat((Object)result.getValueAt(30, 4)).isEqualTo((Object)date);
        Assertions.assertThat((Object)result.getValueAt(30, 5)).isEqualTo((Object)"Raleigh");
        Assertions.assertThat((Object)result.getValueAt(46, 0)).isEqualTo((Object)47.0);
        Assertions.assertThat((Object)result.getValueAt(46, 1)).isEqualTo((Object)565.56);
        Assertions.assertThat((Object)result.getValueAt(46, 2)).isEqualTo((Object)"Management");
        Assertions.assertThat((Object)result.getValueAt(46, 3)).isEqualTo((Object)"Patricia J. Behr");
        date = new SimpleDateFormat(DATE_FORMAT).parse("2012-04-14 -0900");
        Assertions.assertThat((Object)result.getValueAt(46, 4)).isEqualTo((Object)date);
        Assertions.assertThat((Object)result.getValueAt(46, 5)).isEqualTo((Object)"London");
    }

    @Test
    public void testDefaultLookupWithSorting() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("EXPENSES_ID", SortOrder.DESCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(50);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)50.0);
        Assertions.assertThat((Object)result.getValueAt(49, 0)).isEqualTo((Object)1.0);
    }

    @Test(expected=RuntimeException.class)
    public void testSortingWithNonExistingColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("mycolumn", SortOrder.DESCENDING)).buildLookup());
    }

    @Test
    public void testLookupTrim() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("EXPENSES_ID", SortOrder.ASCENDING)).rowNumber(10)).rowOffset(40)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(10);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)41.0);
        Assertions.assertThat((Object)result.getValueAt(9, 0)).isEqualTo((Object)50.0);
        Assertions.assertThat((Object)result.getValueAt(6, 0)).isEqualTo((Object)47.0);
        Assertions.assertThat((Object)result.getValueAt(6, 1)).isEqualTo((Object)565.56);
        Assertions.assertThat((Object)result.getValueAt(6, 2)).isEqualTo((Object)"Management");
        Assertions.assertThat((Object)result.getValueAt(6, 3)).isEqualTo((Object)"Patricia J. Behr");
        Date date = new SimpleDateFormat(DATE_FORMAT).parse("2012-04-14 -0900");
        Assertions.assertThat((Object)result.getValueAt(6, 4)).isEqualTo((Object)date);
        Assertions.assertThat((Object)result.getValueAt(6, 5)).isEqualTo((Object)"London");
    }

    @Test(expected=RuntimeException.class)
    public void testAggregationByNoFunctionColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).column("DEPARTMENT", "Department")).column(AggregateFunctionType.COUNT, "#items")).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
    }

    @Test
    public void testAggregationWithColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("DEPARTMENT")).column("DEPARTMENT", "Department")).column(AggregateFunctionType.COUNT, "#items")).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(5);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)"Engineering");
        Assertions.assertThat((Object)result.getValueAt(0, 1)).isEqualTo((Object)19.0);
        Assertions.assertThat((Object)result.getValueAt(1, 0)).isEqualTo((Object)"Management");
        Assertions.assertThat((Object)result.getValueAt(1, 1)).isEqualTo((Object)11.0);
        Assertions.assertThat((Object)result.getValueAt(2, 0)).isEqualTo((Object)"Sales");
        Assertions.assertThat((Object)result.getValueAt(2, 1)).isEqualTo((Object)8.0);
        Assertions.assertThat((Object)result.getValueAt(3, 0)).isEqualTo((Object)"Services");
        Assertions.assertThat((Object)result.getValueAt(3, 1)).isEqualTo((Object)5.0);
        Assertions.assertThat((Object)result.getValueAt(4, 0)).isEqualTo((Object)"Support");
        Assertions.assertThat((Object)result.getValueAt(4, 1)).isEqualTo((Object)7.0);
    }

    @Test(expected=RuntimeException.class)
    public void testAggregationFunctionByNonExistingColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("DEPARTMENT")).column("DEPARTMENT", "Department")).column(AggregateFunctionType.COUNT, "Occurrences")).column("mycolumn", AggregateFunctionType.MIN, "min")).buildLookup());
    }

    @Test
    public void testFilterEqualsByStringNotAnalyzed() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("CITY", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(6);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)5, (int)0, (String)"6.00");
    }

    @Test
    public void testFilterEqualsByStringAnalyzed() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Nita Marling"))})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"9.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)3, (int)0, (String)"12.00");
    }

    @Test
    public void testFilterLikeToByStringAnalyzedAndCaseSensitive() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.likeTo((String)"EMPLOYEE", (String)"Jul%", (boolean)true)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.likeTo((String)"EMPLOYEE", (String)"jul%", (boolean)true)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CSENSITIVE_UUID)).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.likeTo((String)"EMPLOYEE", (String)"Jul%", (boolean)true)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CSENSITIVE_UUID)).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.likeTo((String)"EMPLOYEE", (String)"jul%", (boolean)true)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(0);
    }

    @Test
    public void testFilterLikeToByStringAnalyzedAndCaseUnSensitive() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.likeTo((String)"EMPLOYEE", (String)"Jul%", (boolean)false)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.likeTo((String)"EMPLOYEE", (String)"jul%", (boolean)false)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CSENSITIVE_UUID)).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.likeTo((String)"EMPLOYEE", (String)"Jul%", (boolean)false)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CSENSITIVE_UUID)).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.likeTo((String)"EMPLOYEE", (String)"jul%", (boolean)false)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(0);
    }

    @Test
    public void testFilterLikeToByStringNotAnalyzedAndCaseSensitive() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("DEPARTMENT", new ColumnFilter[]{FilterFactory.likeTo((String)"DEPARTMENT", (String)"Sal%", (boolean)true)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(8);
    }

    @Test(expected=RuntimeException.class)
    public void testFilterLikeToByStringNotAnalyzedAndCaseUnSensitive() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("DEPARTMENT", new ColumnFilter[]{FilterFactory.likeTo((String)"DEPARTMENT", (String)"Sal%", (boolean)false)})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
    }

    @Test
    public void testFilterMultiple() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("AMOUNT", new ColumnFilter[]{FilterFactory.lowerOrEqualsTo((Comparable)Double.valueOf(120.35))})).filter("CITY", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("CITY", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).filter("AMOUNT", new ColumnFilter[]{FilterFactory.lowerOrEqualsTo((Comparable)Double.valueOf(120.35))})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
    }

    @Test
    public void testFilterMultiple2() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("CITY", new ColumnFilter[]{FilterFactory.notEqualsTo((Comparable)((Object)"Barcelona"))})).filter("AMOUNT", new ColumnFilter[]{FilterFactory.greaterOrEqualsTo((Comparable)Integer.valueOf(1000))})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"15.00");
    }

    @Test(expected=RuntimeException.class)
    public void testFilterByNonExistingColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("myfield", new ColumnFilter[]{FilterFactory.greaterOrEqualsTo((Comparable)Integer.valueOf(1000))})).buildLookup());
    }

    @Test
    public void testANDExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("AMOUNT", new ColumnFilter[]{FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(100)), FilterFactory.lowerThan((Comparable)Integer.valueOf(150))})})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
    }

    @Test
    public void testORExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("AMOUNT", new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.lowerThan((Comparable)Integer.valueOf(200)), FilterFactory.greaterThan((Comparable)Integer.valueOf(1000))})})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(11);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"2.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"6.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)3, (int)0, (String)"9.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)4, (int)0, (String)"10.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)5, (int)0, (String)"15.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)6, (int)0, (String)"17.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)7, (int)0, (String)"23.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)8, (int)0, (String)"24.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)9, (int)0, (String)"30.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)10, (int)0, (String)"33.00");
    }

    @Test
    public void testNOTExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("AMOUNT", new ColumnFilter[]{FilterFactory.NOT((ColumnFilter[])new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(200))})})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(9);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"6.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"9.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)3, (int)0, (String)"10.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)4, (int)0, (String)"17.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)5, (int)0, (String)"23.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)6, (int)0, (String)"24.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)7, (int)0, (String)"30.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)8, (int)0, (String)"33.00");
    }

    @Test
    public void testCombinedExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("AMOUNT", new ColumnFilter[]{FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((String)"DEPARTMENT", (Comparable)((Object)"Sales")), FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.NOT((ColumnFilter[])new ColumnFilter[]{FilterFactory.lowerThan((Comparable)Integer.valueOf(300))}), FilterFactory.equalsTo((String)"CITY", (Comparable)((Object)"Madrid"))})})})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(7);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"9.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)6, (int)0, (String)"28.00");
    }

    @Test
    public void testFilterByAnalyzedAndNonAnalyzedColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("CITY", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Jamie Gilbeau"))})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"4.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"5.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"6.00");
    }

    @Test
    public void testFilterByNonAnalyzedAndNonAnalyzedColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("CITY", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).filter("DEPARTMENT", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Engineering"))})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"2.00");
        org.dashbuilder.dataset.Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"3.00");
    }

    @Test
    public void testAggregationAndFilterByAnalyzedField() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).column(AggregateFunctionType.COUNT, "#items")).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Roxie Foraker"))})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)5.0);
    }

    @Test
    public void testAggregationAndFilterByNonAnalyzedField() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).column(AggregateFunctionType.COUNT, "#items")).filter("DEPARTMENT", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Engineering"))})).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)19.0);
    }
}

