/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.dashbuilder.dataprovider.kafka.mbean.MBeanServerConnectionProvider;
import org.dashbuilder.dataprovider.kafka.metrics.KafkaMetricCollector;
import org.dashbuilder.dataprovider.kafka.metrics.group.MetricsCollectorGroupFactory;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetric;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetricsRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMetricsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaMetricsProvider.class);
    private static KafkaMetricsProvider instance;
    MetricsCollectorGroupFactory metricsCollectorGroupFactory;

    KafkaMetricsProvider(MetricsCollectorGroupFactory metricsCollectorGroupFactory) {
        this.metricsCollectorGroupFactory = metricsCollectorGroupFactory;
    }

    public static KafkaMetricsProvider get() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KafkaMetric> getMetrics(KafkaMetricsRequest request) {
        List<KafkaMetricCollector> extractors = this.collectorsFor(request);
        JMXConnector connector = MBeanServerConnectionProvider.newConnection(request);
        try {
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            List<KafkaMetric> list = this.extractMetrics(mbsc, extractors);
            return list;
        }
        catch (Exception e) {
            LOGGER.warn("Error reading metrics for request {}", (Object)request);
            LOGGER.debug("Error reading metrics for request", (Throwable)e);
            List<KafkaMetric> list = Collections.emptyList();
            return list;
        }
        finally {
            try {
                connector.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing JMX connector");
                LOGGER.debug("Error closing JMX Connector", (Throwable)e);
            }
        }
    }

    List<KafkaMetricCollector> collectorsFor(KafkaMetricsRequest request) {
        List<KafkaMetricCollector> collectors = this.metricsCollectorGroupFactory.forTarget(request.getMetricsTarget()).getMetricsCollectors(request);
        return request.filter().map(f -> this.filtering(collectors, (String)f)).orElse(collectors);
    }

    List<KafkaMetricCollector> filtering(List<KafkaMetricCollector> collectors, String filter) {
        return filter.trim().isEmpty() ? collectors : collectors.stream().filter(c -> c.getName().toLowerCase().contains(filter.toLowerCase())).collect(Collectors.toList());
    }

    private List<KafkaMetric> extractMetrics(MBeanServerConnection mbsc, List<KafkaMetricCollector> extractors) {
        return extractors.stream().flatMap(e -> e.collect(mbsc).stream()).collect(Collectors.toList());
    }

    static {
        MetricsCollectorGroupFactory metricsCollectorGroupFactory = MetricsCollectorGroupFactory.get();
        instance = new KafkaMetricsProvider(metricsCollectorGroupFactory);
    }
}

