/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.mbean;

import org.dashbuilder.dataprovider.kafka.mbean.ObjectNameBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ObjectNameBuilderTest {
    @Test
    public void testBuildWithName() {
        String objectName = ObjectNameBuilder.create((String)"my.domain").type("MyType").name("MyName").build();
        Assert.assertEquals((Object)"my.domain:type=MyType,name=MyName", (Object)objectName);
    }

    @Test
    public void testBuildWithRequest() {
        String objectName = ObjectNameBuilder.create((String)"my.domain").type("MyType").name("MyName").request("MyRequest").build();
        Assert.assertEquals((Object)"my.domain:type=MyType,name=MyName,request=MyRequest", (Object)objectName);
    }

    @Test
    public void testBuildWithDelayedOperation() {
        String objectName = ObjectNameBuilder.create((String)"my.domain").type("MyType").name("MyName").request("MyRequest").delayedOperation("MyOp").build();
        Assert.assertEquals((Object)"my.domain:type=MyType,name=MyName,request=MyRequest,delayedOperation=MyOp", (Object)objectName);
    }

    @Test
    public void testBuildWithClientId() {
        String objectName = ObjectNameBuilder.create((String)"my.domain").type("MyType").name("MyName").request("MyRequest").delayedOperation("MyOp").clientId("MyClientId").build();
        Assert.assertEquals((Object)"my.domain:type=MyType,name=MyName,request=MyRequest,delayedOperation=MyOp,clientId=MyClientId", (Object)objectName);
    }

    @Test
    public void testBuildWithTopic() {
        String objectName = ObjectNameBuilder.create((String)"my.domain").type("MyType").clientId("MyClientId").topic("MyTopic").build();
        Assert.assertEquals((Object)"my.domain:type=MyType,clientId=MyClientId,topic=MyTopic", (Object)objectName);
    }

    @Test
    public void testBuildWithNodeId() {
        String objectName = ObjectNameBuilder.create((String)"my.domain").type("MyType").clientId("MyClientId").nodeId("MyNode").build();
        Assert.assertEquals((Object)"my.domain:type=MyType,clientId=MyClientId,nodeId=MyNode", (Object)objectName);
    }

    @Test
    public void testBuildWithHyfenClientId() {
        String objectName = ObjectNameBuilder.create((String)"my.domain").type("MyType").hyfenClientId("MyClientId").build();
        Assert.assertEquals((Object)"my.domain:type=MyType,client-id=MyClientId", (Object)objectName);
    }

    @Test
    public void testWithHyfenNodeId() {
        String objectName = ObjectNameBuilder.create((String)"my.domain").type("MyType").hyfenNodeId("MyNodeId").build();
        Assert.assertEquals((Object)"my.domain:type=MyType,node-id=MyNodeId", (Object)objectName);
    }

    @Test
    public void testWithPartition() {
        String objectName = ObjectNameBuilder.create((String)"my.domain").type("MyType").partition("0").build();
        Assert.assertEquals((Object)"my.domain:type=MyType,partition=0", (Object)objectName);
    }
}

