/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dashbuilder.dataprovider.kafka.KafkaDataSetProvider;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetric;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetricsRequest;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.def.KafkaDataSetDef;
import org.junit.Assert;
import org.junit.Test;

public class KafkaDataSetProviderTest {
    @Test
    public void testToDataSet() throws Exception {
        KafkaDataSetProvider provider = new KafkaDataSetProvider();
        String domain1 = "domain1";
        String type1 = "type1";
        String name1 = "name1";
        String attr1 = "attr";
        double value1 = 2.0;
        List<KafkaMetric> metrics = Arrays.asList(KafkaMetric.from((String)domain1, (String)type1, (String)name1, (String)attr1, (Object)value1));
        DataSet dataset = provider.toDataSet(metrics);
        Assert.assertEquals((long)1L, (long)dataset.getRowCount());
        DataColumn domainCl = dataset.getColumnById("DOMAIN");
        DataColumn typeCl = dataset.getColumnById("TYPE");
        DataColumn nameCl = dataset.getColumnById("NAME");
        DataColumn attributeCl = dataset.getColumnById("ATTRIBUTE");
        DataColumn valueCl = dataset.getColumnById("VALUE");
        Assert.assertEquals((Object)domain1, domainCl.getValues().get(0));
        Assert.assertEquals((Object)type1, typeCl.getValues().get(0));
        Assert.assertEquals((Object)name1, nameCl.getValues().get(0));
        Assert.assertEquals((Object)attr1, attributeCl.getValues().get(0));
        Assert.assertEquals((Object)value1, valueCl.getValues().get(0));
    }

    @Test
    public void testToDataSetEmtpy() throws Exception {
        KafkaDataSetProvider provider = new KafkaDataSetProvider();
        DataSet dataset = provider.toDataSet(Collections.emptyList());
        Assert.assertEquals((long)0L, (long)dataset.getRowCount());
    }

    @Test
    public void testNoMetricsErrorMessage() {
        KafkaDataSetProvider provider = new KafkaDataSetProvider();
        KafkaMetricsRequest request = KafkaMetricsRequest.Builder.newBuilder((String)"", (String)"").build();
        String message = provider.noMetricsErrorMessage(request);
        Assert.assertEquals((Object)"No metrics were found. Check if the BROKER has available metrics and the filter matches any metrics", (Object)message);
        request = KafkaMetricsRequest.Builder.newBuilder((String)"", (String)"").target(KafkaDataSetDef.MetricsTarget.PRODUCER).clientId("c").build();
        message = provider.noMetricsErrorMessage(request);
        Assert.assertEquals((Object)"No metrics were found. Check if the PRODUCER has available metrics, client id c is correct and the filter matches any metrics", (Object)message);
        request = KafkaMetricsRequest.Builder.newBuilder((String)"", (String)"").target(KafkaDataSetDef.MetricsTarget.CONSUMER).clientId("c").build();
        message = provider.noMetricsErrorMessage(request);
        Assert.assertEquals((Object)"No metrics were found. Check if the CONSUMER has available metrics, client id c is correct and the filter matches any metrics", (Object)message);
        request = KafkaMetricsRequest.Builder.newBuilder((String)"", (String)"").target(KafkaDataSetDef.MetricsTarget.CONSUMER).nodeId("n").build();
        message = provider.noMetricsErrorMessage(request);
        Assert.assertEquals((Object)"No metrics were found. Check if the CONSUMER has available metrics, node id n is correct and the filter matches any metrics", (Object)message);
        request = KafkaMetricsRequest.Builder.newBuilder((String)"", (String)"").target(KafkaDataSetDef.MetricsTarget.CONSUMER).topic("t").build();
        message = provider.noMetricsErrorMessage(request);
        Assert.assertEquals((Object)"No metrics were found. Check if the CONSUMER has available metrics, topic t is correct and the filter matches any metrics", (Object)message);
    }
}

