/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.dataprovider.kafka.KafkaMetricsProvider;
import org.dashbuilder.dataprovider.kafka.metrics.KafkaMetricCollector;
import org.dashbuilder.dataprovider.kafka.metrics.group.MetricsCollectorGroup;
import org.dashbuilder.dataprovider.kafka.metrics.group.MetricsCollectorGroupFactory;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetricsRequest;
import org.dashbuilder.dataset.def.KafkaDataSetDef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KafkaMetricsProviderTest {
    @Mock
    private MetricsCollectorGroupFactory groupsFactory;
    @Mock
    private KafkaMetricsRequest request;
    @Mock
    private MetricsCollectorGroup group;
    @InjectMocks
    private KafkaMetricsProvider provider;

    @Before
    public void setup() {
        Mockito.when((Object)this.request.getMetricsTarget()).thenReturn((Object)KafkaDataSetDef.MetricsTarget.BROKER);
        ((MetricsCollectorGroup)Mockito.doReturn(Arrays.asList(this.mockCollector("abc"), this.mockCollector("def"), this.mockCollector("ghi"), this.mockCollector("adg"))).when((Object)this.group)).getMetricsCollectors(this.request);
        Mockito.when((Object)this.groupsFactory.forTarget(KafkaDataSetDef.MetricsTarget.BROKER)).thenReturn((Object)this.group);
    }

    @Test
    public void testCollectorsFor() {
        Mockito.when((Object)this.request.filter()).thenReturn(Optional.empty());
        List selectedCollectors = this.provider.collectorsFor(this.request);
        Assert.assertEquals((long)4L, (long)selectedCollectors.size());
        Mockito.when((Object)this.request.filter()).thenReturn(Optional.of("a"));
        selectedCollectors = this.provider.collectorsFor(this.request);
        Assert.assertEquals((long)2L, (long)selectedCollectors.size());
        Mockito.when((Object)this.request.filter()).thenReturn(Optional.of("  "));
        selectedCollectors = this.provider.collectorsFor(this.request);
        Assert.assertEquals((long)4L, (long)selectedCollectors.size());
    }

    @Test
    public void testCollectorsForWithFilterCase() {
        Mockito.when((Object)this.request.filter()).thenReturn(Optional.of("AbC"));
        List selectedCollectors = this.provider.collectorsFor(this.request);
        Assert.assertEquals((long)1L, (long)selectedCollectors.size());
    }

    private KafkaMetricCollector mockCollector(String name) {
        KafkaMetricCollector collector = (KafkaMetricCollector)Mockito.mock(KafkaMetricCollector.class);
        Mockito.when((Object)collector.getName()).thenReturn((Object)name);
        return collector;
    }
}

