/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.prometheus;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.dashbuilder.dataprovider.prometheus.PrometheusDataSetProvider;
import org.dashbuilder.dataprovider.prometheus.client.QueryResponse;
import org.dashbuilder.dataprovider.prometheus.client.Result;
import org.dashbuilder.dataprovider.prometheus.client.Value;
import org.dashbuilder.dataset.DataSet;
import org.junit.Assert;
import org.junit.Test;

public class PrometheusDataSetProviderTest {
    @Test
    public void toDataSetTest() {
        PrometheusDataSetProvider provider = new PrometheusDataSetProvider();
        QueryResponse response = new QueryResponse();
        HashMap<String, String> metric1 = new HashMap<String, String>();
        String M1_CL = "M1";
        String M2_CL = "M2";
        metric1.put("M1", "abc1");
        metric1.put("M2", "abc2");
        List<Value> values1 = Arrays.asList(Value.of((long)1L, (String)"2"), Value.of((long)3L, (String)"4"));
        HashMap<String, String> metric2 = new HashMap<String, String>();
        metric2.put("M1", "abc3");
        metric2.put("M2", "abc4");
        List<Value> values2 = Arrays.asList(Value.of((long)123L, (String)"42"), Value.of((long)321L, (String)"24"));
        Result result1 = new Result(metric1, values1);
        Result result2 = new Result(metric2, values2);
        List<Result> results = Arrays.asList(result1, result2);
        response.setResults(results);
        DataSet dataSet = provider.toDataSet(response);
        Assert.assertEquals((long)4L, (long)dataSet.getColumns().size());
        Assert.assertEquals((long)4L, (long)dataSet.getRowCount());
        List m1Cl = dataSet.getColumnById("M1").getValues();
        Assert.assertTrue((boolean)m1Cl.contains("abc1"));
        Assert.assertTrue((boolean)m1Cl.contains("abc3"));
        List m2Cl = dataSet.getColumnById("M2").getValues();
        Assert.assertTrue((boolean)m2Cl.contains("abc2"));
        Assert.assertTrue((boolean)m2Cl.contains("abc4"));
        List timeCl = dataSet.getColumnById("TIME").getValues();
        Object[] expectedTimes = new Object[]{1.0, 3.0, 123.0, 321.0};
        Assert.assertArrayEquals((Object[])timeCl.toArray(), (Object[])expectedTimes);
        List valueCl = dataSet.getColumnById("VALUE").getValues();
        Object[] expectedValues = new Object[]{2.0, 4.0, 42.0, 24.0};
        Assert.assertArrayEquals((Object[])valueCl.toArray(), (Object[])expectedValues);
    }

    @Test
    public void emptyQueryResponseToDataSetTest() {
        PrometheusDataSetProvider provider = new PrometheusDataSetProvider();
        QueryResponse response = new QueryResponse();
        DataSet dataSet = provider.toDataSet(response);
        Assert.assertEquals((long)0L, (long)dataSet.getRowCount());
        Assert.assertEquals((long)2L, (long)dataSet.getColumns().size());
    }
}

