/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.prometheus.client;

import org.dashbuilder.dataprovider.prometheus.client.HttpClient;
import org.dashbuilder.dataprovider.prometheus.client.PrometheusClient;
import org.dashbuilder.dataprovider.prometheus.client.QueryResponseParser;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PrometheusClientTest {
    private static final String BASE_URL = "http://localhost:9090/";
    @Mock
    HttpClient httpClient;
    @Mock
    QueryResponseParser parser;
    @InjectMocks
    PrometheusClient prometheusClient;

    @Before
    public void setup() {
        this.prometheusClient.setBaseUrl(BASE_URL);
    }

    @Test
    public void testQueryResponse() {
        this.prometheusClient.query("up");
        ((HttpClient)Mockito.verify((Object)this.httpClient)).doGet((String)Matchers.eq((Object)"http://localhost:9090/api/v1/query?query=up"), (String)Matchers.eq(null), (String)Matchers.eq(null));
    }

    @Test
    public void testQueryRangeResponse() {
        this.prometheusClient.queryRange("up", "startDate", "endDate", "step");
        ((HttpClient)Mockito.verify((Object)this.httpClient)).doGet((String)Matchers.eq((Object)"http://localhost:9090/api/v1/query_range?query=up&start=startDate&end=endDate&step=step"), (String)Matchers.eq(null), (String)Matchers.eq(null));
    }

    @Test
    public void testQueryResponseWithCredentials() {
        System.setProperty("dashbuilder.prometheus.user", "usr");
        System.setProperty("dashbuilder.prometheus.password", "psw");
        this.prometheusClient.query("up");
        ((HttpClient)Mockito.verify((Object)this.httpClient)).doGet((String)Matchers.eq((Object)"http://localhost:9090/api/v1/query?query=up"), (String)Matchers.eq((Object)"usr"), (String)Matchers.eq((Object)"psw"));
        System.clearProperty("dashbuilder.prometheus.user");
        System.clearProperty("dashbuilder.prometheus.password");
    }
}

