/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.prometheus.client;

import java.util.Collections;
import java.util.List;
import org.dashbuilder.dataprovider.prometheus.client.QueryResponse;
import org.dashbuilder.dataprovider.prometheus.client.Result;
import org.dashbuilder.dataprovider.prometheus.client.ResultType;
import org.dashbuilder.dataprovider.prometheus.client.Status;

public class QueryResponseBuilder {
    private Status status;
    private ResultType resultType;
    private String errorType;
    private String error;
    private List<Result> results = Collections.emptyList();

    private QueryResponseBuilder() {
    }

    public static QueryResponseBuilder newQueryResponseBuilder() {
        return new QueryResponseBuilder();
    }

    public QueryResponseBuilder status(Status status) {
        this.status = status;
        return this;
    }

    public QueryResponseBuilder resultType(ResultType resultType) {
        this.resultType = resultType;
        return this;
    }

    public QueryResponseBuilder errorType(String errorType) {
        this.errorType = errorType;
        return this;
    }

    public QueryResponseBuilder error(String error) {
        this.error = error;
        return this;
    }

    public QueryResponseBuilder results(List<Result> results) {
        this.results = results;
        return this;
    }

    public QueryResponse build() {
        QueryResponse queryResponse = new QueryResponse();
        queryResponse.setStatus(this.status);
        queryResponse.setResultType(this.resultType);
        queryResponse.setErrorType(this.errorType);
        queryResponse.setError(this.error);
        queryResponse.setResults(this.results);
        return queryResponse;
    }
}

