/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.prometheus.client;

import java.util.List;
import java.util.Map;
import org.dashbuilder.dataprovider.prometheus.client.MetricHelper;
import org.dashbuilder.dataprovider.prometheus.client.QueryResponse;
import org.dashbuilder.dataprovider.prometheus.client.QueryResponseParser;
import org.dashbuilder.dataprovider.prometheus.client.Result;
import org.dashbuilder.dataprovider.prometheus.client.ResultType;
import org.dashbuilder.dataprovider.prometheus.client.Status;
import org.dashbuilder.dataprovider.prometheus.client.Value;
import org.junit.Assert;
import org.junit.Test;

public class QueryResponseParserTest {
    private final String VECTOR_JSON = "{\"status\":\"success\",\"data\":{\"resultType\":\"vector\",\"result\":[{\"metric\":{\"__name__\":\"up\",\"instance\":\"localhost:9090\",\"job\":\"prometheus\"},\"value\":[1608760240.193,\"1\"]}]}}";
    private final String MATRIX_JSON = "{\"status\":\"success\",\"data\":{\"resultType\":\"matrix\",\"result\":[{\"metric\":{\"__name__\":\"up\",\"job\":\"prometheus\",\"instance\":\"localhost:9090\"},\"values\":[[1435781430.781,\"1\"],[1435781445.781,\"1\"]]},{\"metric\":{\"__name__\":\"up\",\"job\":\"node\",\"instance\":\"localhost:9091\"},\"values\":[[1435781430.781,\"0\"],[1435781445.781,\"1\"]]}]}}";
    private final String SCALAR_JSON = "{\"status\":\"success\",\"data\":{\"resultType\":\"scalar\",\"result\":[1608819321.842,\"10\"]}}";
    private final String METRIC_PARAM_JSON = "{\"status\":\"success\",\"data\":{\"resultType\":\"vector\",\"result\":[{\"metric\":{\"attr\":\"attr_val\"},\"value\":[1609169361.502,\"12\"]}]}}";
    private final String ERROR_RESPONSE_JSON = "{\"status\":\"error\",\"errorType\":\"error type\",\"error\":\"error message\"}";

    @Test
    public void testParseVectorResponse() {
        QueryResponse response = QueryResponseParser.get().parse("{\"status\":\"success\",\"data\":{\"resultType\":\"vector\",\"result\":[{\"metric\":{\"__name__\":\"up\",\"instance\":\"localhost:9090\",\"job\":\"prometheus\"},\"value\":[1608760240.193,\"1\"]}]}}");
        Assert.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assert.assertEquals((Object)ResultType.VECTOR, (Object)response.getResultType());
        Result result = (Result)response.getResults().get(0);
        Map metric = result.getMetric();
        Assert.assertEquals((Object)"up", (Object)MetricHelper.getName((Map)metric));
        Assert.assertEquals((Object)"localhost:9090", (Object)MetricHelper.getInstance((Map)metric));
        Assert.assertEquals((Object)"prometheus", (Object)MetricHelper.getJob((Map)metric));
        List values = result.getValues();
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((long)1608760240L, (long)((Value)values.get(0)).getTimestamp());
        Assert.assertEquals((Object)"1", (Object)((Value)values.get(0)).getValue());
    }

    @Test
    public void testParseMatrixResponse() {
        QueryResponse response = QueryResponseParser.get().parse("{\"status\":\"success\",\"data\":{\"resultType\":\"matrix\",\"result\":[{\"metric\":{\"__name__\":\"up\",\"job\":\"prometheus\",\"instance\":\"localhost:9090\"},\"values\":[[1435781430.781,\"1\"],[1435781445.781,\"1\"]]},{\"metric\":{\"__name__\":\"up\",\"job\":\"node\",\"instance\":\"localhost:9091\"},\"values\":[[1435781430.781,\"0\"],[1435781445.781,\"1\"]]}]}}");
        Assert.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assert.assertEquals((Object)ResultType.MATRIX, (Object)response.getResultType());
        Result result1 = (Result)response.getResults().get(0);
        Map metric1 = result1.getMetric();
        Assert.assertEquals((Object)"up", (Object)MetricHelper.getName((Map)metric1));
        Assert.assertEquals((Object)"localhost:9090", (Object)MetricHelper.getInstance((Map)metric1));
        Assert.assertEquals((Object)"prometheus", (Object)MetricHelper.getJob((Map)metric1));
        List values = result1.getValues();
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((long)1435781430L, (long)((Value)values.get(0)).getTimestamp());
        Assert.assertEquals((Object)"1", (Object)((Value)values.get(0)).getValue());
        Assert.assertEquals((long)0x55944945L, (long)((Value)values.get(1)).getTimestamp());
        Assert.assertEquals((Object)"1", (Object)((Value)values.get(1)).getValue());
        Result result2 = (Result)response.getResults().get(1);
        Map metric2 = result2.getMetric();
        Assert.assertEquals((Object)"up", (Object)MetricHelper.getName((Map)metric2));
        Assert.assertEquals((Object)"localhost:9091", (Object)MetricHelper.getInstance((Map)metric2));
        Assert.assertEquals((Object)"node", (Object)MetricHelper.getJob((Map)metric2));
        List values2 = result2.getValues();
        Assert.assertEquals((long)2L, (long)values2.size());
        Assert.assertEquals((long)1435781430L, (long)((Value)values2.get(0)).getTimestamp());
        Assert.assertEquals((Object)"0", (Object)((Value)values2.get(0)).getValue());
        Assert.assertEquals((long)0x55944945L, (long)((Value)values2.get(1)).getTimestamp());
        Assert.assertEquals((Object)"1", (Object)((Value)values2.get(1)).getValue());
    }

    @Test
    public void testParseScalarResponse() {
        QueryResponse response = QueryResponseParser.get().parse("{\"status\":\"success\",\"data\":{\"resultType\":\"scalar\",\"result\":[1608819321.842,\"10\"]}}");
        Assert.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assert.assertEquals((Object)ResultType.SCALAR, (Object)response.getResultType());
        Value value = (Value)((Result)response.getResults().get(0)).getValues().get(0);
        Assert.assertEquals((long)1608819321L, (long)value.getTimestamp());
        Assert.assertEquals((Object)"10", (Object)value.getValue());
    }

    @Test
    public void testMetricAttributeResponse() {
        QueryResponse response = QueryResponseParser.get().parse("{\"status\":\"success\",\"data\":{\"resultType\":\"vector\",\"result\":[{\"metric\":{\"attr\":\"attr_val\"},\"value\":[1609169361.502,\"12\"]}]}}");
        Assert.assertEquals((Object)Status.SUCCESS, (Object)response.getStatus());
        Assert.assertEquals((Object)ResultType.VECTOR, (Object)response.getResultType());
        Assert.assertEquals((Object)"attr_val", ((Result)response.getResults().get(0)).getMetric().get("attr"));
    }

    @Test
    public void testErrorResponse() {
        QueryResponse response = QueryResponseParser.get().parse("{\"status\":\"error\",\"errorType\":\"error type\",\"error\":\"error message\"}");
        Assert.assertEquals((Object)Status.ERROR, (Object)response.getStatus());
        Assert.assertEquals((Object)"error message", (Object)response.getError());
        Assert.assertEquals((Object)"error type", (Object)response.getErrorType());
    }
}

