/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.util;

public class DatabaseProvider {
    public static String fromDriverClassName(String driverClassName) {
        if (driverClassName == null || driverClassName.isEmpty()) {
            throw new IllegalArgumentException("Driver class name cannot be empty.");
        }
        String sanitizedDriverClassName = driverClassName.trim().toLowerCase();
        if (sanitizedDriverClassName.startsWith("com.ibm.db2")) {
            return "db2";
        }
        if (sanitizedDriverClassName.startsWith("org.h2")) {
            return "h2";
        }
        if (sanitizedDriverClassName.startsWith("com.microsoft.sqlserver")) {
            return "sqlserver";
        }
        if (sanitizedDriverClassName.startsWith("org.mariadb")) {
            return "mariadb";
        }
        if (sanitizedDriverClassName.startsWith("com.mysql")) {
            return "mysql";
        }
        if (sanitizedDriverClassName.startsWith("oracle")) {
            return "oracle";
        }
        if (sanitizedDriverClassName.startsWith("org.postgresql") || sanitizedDriverClassName.startsWith("com.edb")) {
            return "postgres";
        }
        if (sanitizedDriverClassName.startsWith("com.sybase")) {
            return "sybase";
        }
        throw new IllegalArgumentException("Unsupported database provider with a driver class:" + driverClassName);
    }
}

