/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.dashbuilder.dataprovider.sql.DatabaseTestSettings;
import org.dashbuilder.dataprovider.sql.SQLDataSourceLocator;
import org.dashbuilder.dataprovider.sql.util.DataSourceFactory;
import org.dashbuilder.dataprovider.sql.util.DatabaseProvider;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDatasetTestSettings
extends DatabaseTestSettings {
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    private static final Logger log = LoggerFactory.getLogger(SQLDatasetTestSettings.class);
    private static Properties defaultProperties = null;
    private static Properties props = SQLDatasetTestSettings.getDatasourceProperties();

    public SQLDatasetTestSettings() {
        super(true);
    }

    public String getDatabaseType() {
        String driverClass = props.getProperty("driverClassName");
        return DatabaseProvider.fromDriverClassName(driverClass);
    }

    public SQLDataSourceLocator getDataSourceLocator() {
        return new SQLDataSourceLocator(){

            public DataSource lookup(SQLDataSetDef def) throws Exception {
                return DataSourceFactory.setupPoolingDataSource("test", props);
            }
        };
    }

    public static Properties getDatasourceProperties() {
        String propertiesNotFoundMessage = "Unable to load datasource properties [/datasource.properties]";
        boolean propertiesNotFound = false;
        System.setProperty("h2.lobInDatabase", "true");
        InputStream propsInputStream = SQLDatasetTestSettings.class.getResourceAsStream(DATASOURCE_PROPERTIES);
        if (propsInputStream == null) {
            throw new IllegalStateException(propertiesNotFoundMessage);
        }
        Properties props = new Properties();
        try {
            props.load(propsInputStream);
        }
        catch (IOException ioe) {
            propertiesNotFound = true;
            log.error("Unable to find properties, using default H2 properties: " + ioe.getMessage());
            ioe.printStackTrace();
        }
        String password = props.getProperty("password");
        if ("${maven.jdbc.password}".equals(password) || propertiesNotFound) {
            props = SQLDatasetTestSettings.getDefaultProperties();
        }
        return props;
    }

    private static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            String[] keyArr = new String[]{"serverName", "portNumber", "databaseName", "url", "user", "password", "driverClassName", "className", "maxPoolSize", "allowLocalTransactions"};
            String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:tcp://localhost/TestDS", "sa", "", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "16", "true"};
            if (keyArr.length != defaultPropArr.length) {
                throw new IllegalStateException("Unequal number of keys for default properties!");
            }
            defaultProperties = new Properties();
            IntStream.range(0, keyArr.length).forEach(i -> defaultProperties.put(keyArr[i], defaultPropArr[i]));
        }
        return defaultProperties;
    }
}

