/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.util;

import java.util.Properties;
import org.dashbuilder.dataprovider.sql.util.DatabaseProvider;
import org.dashbuilder.dataprovider.sql.util.PoolingDataSourceWrapper;
import org.dashbuilder.dataprovider.sql.util.PoolingDataSourceWrapperImpl;

public final class DataSourceFactory {
    private DataSourceFactory() {
        throw new UnsupportedOperationException(DataSourceFactory.class.getSimpleName() + " should not be instantiated.");
    }

    public static PoolingDataSourceWrapper setupPoolingDataSource(String datasourceName, Properties driverProperties) {
        return DataSourceFactory.setupPoolingDataSource(datasourceName, driverProperties, new Properties());
    }

    public static PoolingDataSourceWrapper setupPoolingDataSource(String datasourceName, Properties driverProperties, Properties poolingProperties) {
        Properties sanitizedDriverProperties = new Properties();
        String driverClass = driverProperties.getProperty("driverClassName");
        String databaseProvider = DatabaseProvider.fromDriverClassName(driverClass);
        for (String propertyName : new String[]{"user", "password"}) {
            sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
        }
        if (databaseProvider.equals("h2")) {
            for (String propertyName : new String[]{"url", "driverClassName"}) {
                sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
            }
        } else if (databaseProvider.equals("oracle")) {
            sanitizedDriverProperties.put("driverType", "thin");
            sanitizedDriverProperties.put("URL", driverProperties.getProperty("url"));
        } else if (databaseProvider.equals("db2")) {
            for (String propertyName : new String[]{"databaseName", "serverName", "portNumber", "url"}) {
                sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
            }
            sanitizedDriverProperties.put("driverType", "4");
            sanitizedDriverProperties.put("currentSchema", driverProperties.getProperty("defaultSchema"));
            sanitizedDriverProperties.put("ResultSetHoldability", "1");
            sanitizedDriverProperties.put("DowngradeHoldCursorsUnderXa", "true");
        } else if (databaseProvider.equals("sqlserver")) {
            for (String propertyName : new String[]{"serverName", "portNumber", "databaseName"}) {
                sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
            }
            sanitizedDriverProperties.put("URL", driverProperties.getProperty("url"));
        } else if (databaseProvider.equals("mysql") || databaseProvider.equals("mariadb") || databaseProvider.equals("sybase") || databaseProvider.equals("postgres")) {
            for (String propertyName : new String[]{"databaseName", "portNumber", "serverName", "url"}) {
                sanitizedDriverProperties.put(propertyName, driverProperties.getProperty(propertyName));
            }
        } else {
            throw new RuntimeException("Unknown driver class: " + driverClass);
        }
        String xaDataSourceClassName = driverProperties.getProperty("className");
        return new PoolingDataSourceWrapperImpl(datasourceName, xaDataSourceClassName, sanitizedDriverProperties, poolingProperties);
    }
}

