/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.sql.DatabaseTestSettings;
import org.dashbuilder.dataprovider.sql.SQLDataSetProvider;
import org.dashbuilder.dataprovider.sql.SQLDataSourceLocator;
import org.dashbuilder.dataprovider.sql.SQLFactory;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.CreateTable;
import org.dashbuilder.dataprovider.sql.model.DropTable;
import org.dashbuilder.dataprovider.sql.model.Table;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.ExpenseReportsData;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.junit.After;
import org.junit.Before;

public class SQLDataSetTestBase {
    DataSetManager dataSetManager = DataSetCore.get().getDataSetManager();
    DataSetDefRegistry dataSetDefRegistry = DataSetCore.get().getDataSetDefRegistry();
    DataSetFormatter dataSetFormatter = new DataSetFormatter();
    SQLDataSetProvider sqlDataSetProvider = SQLDataSetProvider.get();
    DataSetDefJSONMarshaller jsonMarshaller = DataSetCore.get().getDataSetDefJSONMarshaller();
    DatabaseTestSettings testSettings = this.createTestSettings();
    Connection conn;
    Column ID = SQLFactory.column((String)"EXPENSES_ID", (ColumnType)ColumnType.NUMBER, (int)4);
    Column CITY = SQLFactory.column((String)"CITY", (ColumnType)ColumnType.LABEL, (int)50);
    Column DEPT = SQLFactory.column((String)"DEPARTMENT", (ColumnType)ColumnType.LABEL, (int)50);
    Column EMPLOYEE = SQLFactory.column((String)"EMPLOYEE", (ColumnType)ColumnType.LABEL, (int)50);
    Column DATE = SQLFactory.column((String)"CREATION_DATE", (ColumnType)ColumnType.DATE, (int)4);
    Column AMOUNT = SQLFactory.column((String)"AMOUNT", (ColumnType)ColumnType.NUMBER, (int)4);
    Table EXPENSES = SQLFactory.table((String)"EXPENSE_REPORTS");
    protected static boolean _dbInfoPrinted = false;

    protected DatabaseTestSettings getTestSettings() {
        return this.testSettings;
    }

    protected DatabaseTestSettings createTestSettings() {
        return new DatabaseTestSettings();
    }

    public String getExpenseReportsDsetFile() {
        return this.testSettings.getExpenseReportsTableDsetFile();
    }

    private void printDatabaseInfo() throws Exception {
        if (!_dbInfoPrinted) {
            DatabaseMetaData meta = this.conn.getMetaData();
            System.out.println("\n********************************************************************************************");
            System.out.println(String.format("Database: %s %s", meta.getDatabaseProductName(), meta.getDatabaseProductVersion()));
            System.out.println(String.format("Driver: %s %s", meta.getDriverName(), meta.getDriverVersion()));
            System.out.println("*********************************************************************************************\n");
            _dbInfoPrinted = true;
        }
    }

    @Before
    public void setUp() throws Exception {
        SQLDataSourceLocator dataSourceLocator = this.testSettings.getDataSourceLocator();
        this.sqlDataSetProvider.setDataSourceLocator(dataSourceLocator);
        DataSetProviderRegistry dataSetProviderRegistry = DataSetCore.get().getDataSetProviderRegistry();
        dataSetProviderRegistry.registerDataProvider((DataSetProvider)this.sqlDataSetProvider);
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource(this.getExpenseReportsDsetFile());
        String json = IOUtils.toString((URL)fileURL, (Charset)StandardCharsets.UTF_8);
        SQLDataSetDef def = (SQLDataSetDef)this.jsonMarshaller.fromJson(json);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        DataSource dataSource = dataSourceLocator.lookup(def);
        this.conn = dataSource.getConnection();
        this.printDatabaseInfo();
        ((CreateTable)SQLFactory.createTable((Connection)this.conn).table(this.EXPENSES)).columns(new Column[]{this.ID, this.CITY, this.DEPT, this.EMPLOYEE, this.DATE, this.AMOUNT}).primaryKey(new Column[]{this.ID}).execute();
        this.populateDbTable();
    }

    @After
    public void tearDown() throws Exception {
        ((DropTable)SQLFactory.dropTable((Connection)this.conn).table(this.EXPENSES)).execute();
        this.conn.close();
    }

    public void testAll() throws Exception {
    }

    protected void populateDbTable() throws Exception {
        int rowCount = SQLFactory.select((Connection)this.conn).from(this.EXPENSES).fetchCount();
        DataSet dataSet = ExpenseReportsData.INSTANCE.toDataSet();
        for (int i = 0; i < dataSet.getRowCount(); ++i) {
            int id = ((Number)dataSet.getValueAt(i, 0)).intValue();
            SQLFactory.insert((Connection)this.conn).into(this.EXPENSES).set(this.ID, (Object)(rowCount + id)).set(this.CITY, dataSet.getValueAt(i, 1)).set(this.DEPT, dataSet.getValueAt(i, 2)).set(this.EMPLOYEE, dataSet.getValueAt(i, 3)).set(this.DATE, dataSet.getValueAt(i, 4)).set(this.AMOUNT, dataSet.getValueAt(i, 5)).execute();
        }
    }

    protected void printDataSet(DataSet dataSet) {
        System.out.print(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

