/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataset.ColumnType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JDBCUtilsTest {
    @Mock
    Connection connection;
    @Mock
    Statement statement;
    @Mock
    ResultSet resultSet;
    @Mock
    ResultSetMetaData metaData;
    @Mock
    Clob clob;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.connection.createStatement()).thenReturn((Object)this.statement);
        Mockito.when((Object)this.resultSet.getMetaData()).thenReturn((Object)this.metaData);
    }

    @Test
    public void testStatementClose() throws Exception {
        JDBCUtils.execute((Connection)this.connection, (String)"sql");
        ((Statement)Mockito.verify((Object)this.statement)).execute("sql");
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    @Test
    public void testListDataSourceDefs() throws Exception {
        List defList = JDBCUtils.listDatasourceDefs();
        Assert.assertEquals((long)defList.size(), (long)0L);
    }

    @Test
    public void testFixSQLCase() throws Exception {
        String sql = "SELECT \"ID\" FROM TABLE";
        String fix = JDBCUtils.changeCaseExcludeQuotes((String)sql, (boolean)false);
        Assert.assertEquals((Object)fix, (Object)"select \"ID\" from table");
    }

    @Test
    public void testSupportedTypes() throws Exception {
        Mockito.when((Object)this.metaData.getColumnCount()).thenReturn((Object)35);
        Mockito.when((Object)this.metaData.getColumnType(1)).thenReturn((Object)1);
        Mockito.when((Object)this.metaData.getColumnType(2)).thenReturn((Object)12);
        Mockito.when((Object)this.metaData.getColumnType(3)).thenReturn((Object)-15);
        Mockito.when((Object)this.metaData.getColumnType(4)).thenReturn((Object)-9);
        Mockito.when((Object)this.metaData.getColumnType(5)).thenReturn((Object)-7);
        Mockito.when((Object)this.metaData.getColumnType(6)).thenReturn((Object)16);
        Mockito.when((Object)this.metaData.getColumnType(7)).thenReturn((Object)-1);
        Mockito.when((Object)this.metaData.getColumnType(8)).thenReturn((Object)-16);
        Mockito.when((Object)this.metaData.getColumnType(9)).thenReturn((Object)-6);
        Mockito.when((Object)this.metaData.getColumnType(10)).thenReturn((Object)-5);
        Mockito.when((Object)this.metaData.getColumnType(11)).thenReturn((Object)4);
        Mockito.when((Object)this.metaData.getColumnType(12)).thenReturn((Object)3);
        Mockito.when((Object)this.metaData.getColumnType(13)).thenReturn((Object)8);
        Mockito.when((Object)this.metaData.getColumnType(14)).thenReturn((Object)6);
        Mockito.when((Object)this.metaData.getColumnType(15)).thenReturn((Object)2);
        Mockito.when((Object)this.metaData.getColumnType(16)).thenReturn((Object)7);
        Mockito.when((Object)this.metaData.getColumnType(17)).thenReturn((Object)5);
        Mockito.when((Object)this.metaData.getColumnType(18)).thenReturn((Object)91);
        Mockito.when((Object)this.metaData.getColumnType(19)).thenReturn((Object)92);
        Mockito.when((Object)this.metaData.getColumnType(20)).thenReturn((Object)93);
        Mockito.when((Object)this.metaData.getColumnType(21)).thenReturn((Object)-3);
        Mockito.when((Object)this.metaData.getColumnType(22)).thenReturn((Object)-4);
        Mockito.when((Object)this.metaData.getColumnType(23)).thenReturn((Object)0);
        Mockito.when((Object)this.metaData.getColumnType(24)).thenReturn((Object)1111);
        Mockito.when((Object)this.metaData.getColumnType(25)).thenReturn((Object)2000);
        Mockito.when((Object)this.metaData.getColumnType(26)).thenReturn((Object)2001);
        Mockito.when((Object)this.metaData.getColumnType(27)).thenReturn((Object)2002);
        Mockito.when((Object)this.metaData.getColumnType(28)).thenReturn((Object)2003);
        Mockito.when((Object)this.metaData.getColumnType(29)).thenReturn((Object)2004);
        Mockito.when((Object)this.metaData.getColumnType(30)).thenReturn((Object)2005);
        Mockito.when((Object)this.metaData.getColumnType(31)).thenReturn((Object)2006);
        Mockito.when((Object)this.metaData.getColumnType(32)).thenReturn((Object)-8);
        Mockito.when((Object)this.metaData.getColumnType(33)).thenReturn((Object)2009);
        Mockito.when((Object)this.metaData.getColumnType(34)).thenReturn((Object)70);
        List columns = JDBCUtils.getColumns((ResultSet)this.resultSet, null);
        Assert.assertEquals((long)columns.size(), (long)21L);
        Assert.assertEquals((Object)((Column)columns.get(0)).getType(), (Object)ColumnType.LABEL);
        Assert.assertEquals((Object)((Column)columns.get(1)).getType(), (Object)ColumnType.LABEL);
        Assert.assertEquals((Object)((Column)columns.get(2)).getType(), (Object)ColumnType.LABEL);
        Assert.assertEquals((Object)((Column)columns.get(4)).getType(), (Object)ColumnType.LABEL);
        Assert.assertEquals((Object)((Column)columns.get(5)).getType(), (Object)ColumnType.LABEL);
        Assert.assertEquals((Object)((Column)columns.get(6)).getType(), (Object)ColumnType.TEXT);
        Assert.assertEquals((Object)((Column)columns.get(7)).getType(), (Object)ColumnType.TEXT);
        Assert.assertEquals((Object)((Column)columns.get(8)).getType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)((Column)columns.get(9)).getType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)((Column)columns.get(10)).getType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)((Column)columns.get(11)).getType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)((Column)columns.get(12)).getType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)((Column)columns.get(13)).getType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)((Column)columns.get(14)).getType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)((Column)columns.get(15)).getType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)((Column)columns.get(16)).getType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)((Column)columns.get(17)).getType(), (Object)ColumnType.DATE);
        Assert.assertEquals((Object)((Column)columns.get(18)).getType(), (Object)ColumnType.DATE);
        Assert.assertEquals((Object)((Column)columns.get(19)).getType(), (Object)ColumnType.DATE);
        Assert.assertEquals((Object)((Column)columns.get(20)).getType(), (Object)ColumnType.TEXT);
    }

    @Test
    public void clobToStringTest() throws SQLException {
        String TEST = "TEST";
        StringReader testReader = new StringReader(TEST);
        Mockito.when((Object)this.clob.getCharacterStream()).thenReturn((Object)testReader);
        Assert.assertEquals((Object)TEST, (Object)JDBCUtils.clobToString((Clob)this.clob));
        Assert.assertTrue((boolean)JDBCUtils.clobToString(null).isEmpty());
        Mockito.when((Object)this.clob.getCharacterStream()).thenThrow(new Throwable[]{new RuntimeException()});
        Assert.assertTrue((boolean)JDBCUtils.clobToString((Clob)this.clob).isEmpty());
    }
}

