/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.dashbuilder.dataprovider.sql.SQLDataSetTestBase;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.junit.Assert;
import org.junit.Test;

public class SQLDataSetDefTest
extends SQLDataSetTestBase {
    @Override
    public void testAll() throws Exception {
        if (!this.testSettings.isMonetDB()) {
            this.testAllColumns();
        }
        this.testSQLDataSet();
        this.testColumnSet();
        this.testColumnAlias();
        this.testFilters();
    }

    @Test
    public void testAllColumns() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports_allcolumns.dset");
        String json = IOUtils.toString((URL)fileURL, (Charset)StandardCharsets.UTF_8);
        SQLDataSetDef def = (SQLDataSetDef)this.jsonMarshaller.fromJson(json);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        DataSetMetadata metadata = this.dataSetManager.getDataSetMetadata("expense_reports_allcolumns");
        Assertions.assertThat((int)metadata.getNumberOfColumns()).isEqualTo(6);
        Assertions.assertThat((int)metadata.getEstimatedSize()).isEqualTo(6350);
        Assertions.assertThat((int)metadata.getNumberOfRows()).isEqualTo(50);
    }

    @Test
    public void testNoEstimateSize() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports_allcolumns.dset");
        String json = IOUtils.toString((URL)fileURL, (Charset)StandardCharsets.UTF_8);
        SQLDataSetDef def = (SQLDataSetDef)this.jsonMarshaller.fromJson(json);
        def.setEstimateSize(false);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        DataSetMetadata metadata = this.dataSetManager.getDataSetMetadata("expense_reports_allcolumns");
        Assertions.assertThat((int)metadata.getNumberOfColumns()).isEqualTo(6);
        Assertions.assertThat((int)metadata.getEstimatedSize()).isEqualTo(0);
        Assertions.assertThat((int)metadata.getNumberOfRows()).isEqualTo(0);
    }

    @Test
    public void testSQLDataSet() throws Exception {
        String testDataSetFile = this.testSettings.getExpenseReportsSqlDsetFile();
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource(testDataSetFile);
        String json = IOUtils.toString((URL)fileURL, (Charset)StandardCharsets.UTF_8);
        SQLDataSetDef def = (SQLDataSetDef)this.jsonMarshaller.fromJson(json);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        DataSetMetadata metadata = this.dataSetManager.getDataSetMetadata("expense_reports_sql");
        Assertions.assertThat((int)metadata.getNumberOfColumns()).isEqualTo(3);
        Assertions.assertThat((int)metadata.getNumberOfRows()).isEqualTo(6);
        Assertions.assertThat((int)metadata.getEstimatedSize()).isEqualTo(342);
        String uuid = "expense_reports_sql";
        DataSet dataSet = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports_sql")).filter("AMOUNT", new ColumnFilter[]{FilterFactory.lowerThan((Comparable)Integer.valueOf(1000))})).group("EMPLOYEE")).column("EMPLOYEE")).column("AMOUNT", AggregateFunctionType.SUM)).sort("EMPLOYEE", SortOrder.ASCENDING)).buildLookup());
        SQLDataSetDefTest.assertDataSetDefinition(dataSet, "expense_reports_sql");
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)dataSet, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"Jamie Gilbeau", "792.59"}, {"Roxie Foraker", "1,020.45"}}, (int)0);
    }

    @Test
    public void testColumnSet() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports_columnset.dset");
        String json = IOUtils.toString((URL)fileURL, (Charset)StandardCharsets.UTF_8);
        SQLDataSetDef def = (SQLDataSetDef)this.jsonMarshaller.fromJson(json);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        DataSetMetadata metadata = this.dataSetManager.getDataSetMetadata("expense_reports_columnset");
        Assertions.assertThat((int)metadata.getNumberOfColumns()).isEqualTo(4);
        if (!this.testSettings.isMonetDB()) {
            Assertions.assertThat((int)metadata.getEstimatedSize()).isEqualTo(4300);
            Assertions.assertThat((int)metadata.getNumberOfRows()).isEqualTo(50);
        }
        String uuid = "expense_reports_columnset";
        DataSet dataSet = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports_columnset")).buildLookup());
        Assertions.assertThat((int)dataSet.getColumns().size()).isEqualTo(4);
        Assertions.assertThat((Object)dataSet.getValueAt(0, 0)).isEqualTo((Object)"Engineering");
        Assertions.assertThat((Object)dataSet.getValueAt(0, 1)).isEqualTo((Object)"Roxie Foraker");
        Assertions.assertThat((Object)dataSet.getValueAt(0, 2)).isEqualTo((Object)120.35);
        Assertions.assertThat((String)this.dataSetFormatter.formatValueAt(dataSet, 0, 3)).isEqualTo("12/11/15 12:00");
        SQLDataSetDefTest.assertDataSetDefinition(dataSet, "expense_reports_columnset");
    }

    @Test
    public void testColumnAlias() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports_columnalias.dset");
        String json = IOUtils.toString((URL)fileURL, (Charset)StandardCharsets.UTF_8);
        SQLDataSetDef def = (SQLDataSetDef)this.jsonMarshaller.fromJson(json);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        String uuid = "expense_reports_columnalias";
        DataSetMetadata metadata = this.dataSetManager.getDataSetMetadata(uuid);
        Assertions.assertThat((int)metadata.getNumberOfColumns()).isEqualTo(3);
        Assertions.assertThat((String)metadata.getColumnId(0)).isEqualTo("Id");
        Assertions.assertThat((String)metadata.getColumnId(1)).isEqualTo("Employee");
        Assertions.assertThat((String)metadata.getColumnId(2)).isEqualTo("Amount");
        DataSet dataSet = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(uuid)).filter("id", new ColumnFilter[]{FilterFactory.notNull()})).filter("amount", new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(0)), FilterFactory.lowerThan((Comparable)Integer.valueOf(1000))})})).group("employee")).column("EMPLOYEE", "employee")).column("id", AggregateFunctionType.COUNT, "id")).column("AMOUNT", AggregateFunctionType.SUM, "amount")).sort("id", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)dataSet.getColumns().size()).isEqualTo(3);
        Assert.assertNotNull((Object)dataSet.getColumnById("ID"));
        Assert.assertNotNull((Object)dataSet.getColumnById("EMPLOYEE"));
        Assert.assertNotNull((Object)dataSet.getColumnById("AMOUNT"));
    }

    @Test
    public void testFilters() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports_filtered.dset");
        String json = IOUtils.toString((URL)fileURL, (Charset)StandardCharsets.UTF_8);
        SQLDataSetDef def = (SQLDataSetDef)this.jsonMarshaller.fromJson(json);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        String uuid = "expense_reports_filtered";
        DataSetMetadata metadata = this.dataSetManager.getDataSetMetadata("expense_reports_filtered");
        Assertions.assertThat((int)metadata.getNumberOfColumns()).isEqualTo(5);
        if (!this.testSettings.isMonetDB()) {
            Assertions.assertThat((int)metadata.getEstimatedSize()).isEqualTo(666);
            Assertions.assertThat((int)metadata.getNumberOfRows()).isEqualTo(6);
        }
        DataSet dataSet = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports_filtered")).group("DEPARTMENT")).column("DEPARTMENT")).column("EMPLOYEE")).column("AMOUNT", AggregateFunctionType.SUM)).sort("DEPARTMENT", SortOrder.DESCENDING)).buildLookup());
        SQLDataSetDefTest.assertDataSetDefinition(dataSet, "expense_reports_filtered");
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)dataSet, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"Services", "Jamie Gilbeau", "792.59"}, {"Engineering", "Roxie Foraker", "2,120.55"}}, (int)0);
    }

    public static void assertDataSetDefinition(DataSet dataSet, String uuid) {
        Assertions.assertThat((String)dataSet.getUUID()).isEqualTo(uuid);
        Assertions.assertThat((Object)dataSet.getDefinition()).isNotNull();
        Assertions.assertThat((String)dataSet.getDefinition().getUUID()).isEqualTo(uuid);
    }
}

