/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.dashbuilder.dataprovider.sql.SQLDataSetTestBase;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetTrimTest;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.junit.Test;

public class SQLDataSetTrimTest
extends SQLDataSetTestBase {
    @Override
    public void testAll() throws Exception {
        this.testTrim();
    }

    @Test
    public void testTrim() throws Exception {
        DataSetTrimTest subTest = new DataSetTrimTest();
        subTest.testTrim();
        subTest.testTrimGroup();
        subTest.testDuplicatedColumns();
    }

    @Test
    public void testTotalRowCountNonTrimmedFillingGroupBy() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).group("DEPARTMENT")).column("EXPENSES_ID")).column("CITY")).column("DEPARTMENT")).column("EMPLOYEE")).column("CREATION_DATE")).column("AMOUNT")).rowNumber(10)).rowOffset(0)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(5);
        Assertions.assertThat((int)result.getRowCountNonTrimmed()).isEqualTo(5);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).group("DEPARTMENT")).column("EXPENSES_ID")).column("CITY")).column("DEPARTMENT")).column("EMPLOYEE")).column("CREATION_DATE")).column("AMOUNT")).rowNumber(3)).rowOffset(0)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        Assertions.assertThat((int)result.getRowCountNonTrimmed()).isEqualTo(5);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).group("DEPARTMENT")).column("EXPENSES_ID")).column("CITY")).column("DEPARTMENT")).column("EMPLOYEE")).column("CREATION_DATE")).column("AMOUNT")).rowNumber(5)).rowOffset(5)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(0);
        Assertions.assertThat((int)result.getRowCountNonTrimmed()).isEqualTo(5);
    }

    @Test
    public void testPostFilterDisable() throws Exception {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((String)"DEPARTMENT", Arrays.asList("Sales", "Management")), FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.notEqualsTo((String)"EXPENSES_ID", (Comparable)Integer.valueOf(21)), FilterFactory.isNull((String)"EXPENSES_ID")})})})).filter(new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.isNull((String)"AMOUNT"), FilterFactory.notEqualsTo((String)"AMOUNT", (Comparable)Integer.valueOf(27)), FilterFactory.greaterOrEqualsTo((String)"AMOUNT", (Comparable)Integer.valueOf(1))})})).rowNumber(5)).rowOffset(5)).buildLookup();
        DataSetGroup gOp = new DataSetGroup();
        ColumnGroup cg = new ColumnGroup("EXPENSES_ID", "EXPENSES_ID");
        cg.setPostEnabled(false);
        gOp.setColumnGroup(cg);
        gOp.addGroupFunction(new GroupFunction[]{new GroupFunction("CITY", "CITY", null)});
        gOp.addGroupFunction(new GroupFunction[]{new GroupFunction("DEPARTMENT", "DEPARTMENT", null)});
        gOp.addGroupFunction(new GroupFunction[]{new GroupFunction("EMPLOYEE", "EMPLOYEE", null)});
        gOp.addGroupFunction(new GroupFunction[]{new GroupFunction("CREATION_DATE", "CREATION_DATE", null)});
        gOp.addGroupFunction(new GroupFunction[]{new GroupFunction("AMOUNT", "AMOUNT", null)});
        lookup.addOperation(new DataSetOp[]{gOp});
        DataSet result = this.dataSetManager.lookupDataSet(lookup);
        result.getDefinition();
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(5);
    }
}

