/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration.embedder;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsSource;
import org.appformer.maven.integration.MavenRepositoryConfiguration;
import org.appformer.maven.integration.embedder.MavenEmbedder;
import org.appformer.maven.integration.embedder.MavenEmbedderException;
import org.appformer.maven.integration.embedder.MavenRequest;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.junit.Assert;
import org.junit.Test;

public class MavenEmbedderTest {
    private final String EMPTY_SETTINGS = "<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\"/>\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalRepositories() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            if (oldSettingsXmlPath != null) {
                System.clearProperty("kie.maven.settings.custom");
            }
            MavenSettings.reinitSettingsFromString((String)"<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\"/>\n");
            MavenRequest mavenRequest = MavenEmbedderTest.createMavenRequest(null);
            MavenEmbedderWithRepoMock embedder = new MavenEmbedderWithRepoMock(mavenRequest);
            MavenExecutionRequest request = embedder.getMavenExecutionRequest();
            Assert.assertNotNull((Object)request);
            List remoteRepositories = request.getRemoteRepositories();
            Assert.assertEquals((long)2L, (long)remoteRepositories.size());
            for (ArtifactRepository remoteRepository : remoteRepositories) {
                Assert.assertTrue((remoteRepository.getId().equals("central") || remoteRepository.getId().equals("kie-wb-m2-repo") ? 1 : 0) != 0);
            }
        }
        catch (MavenEmbedderException mee) {
            Assert.fail((String)mee.getMessage());
        }
        finally {
            if (oldSettingsXmlPath != null) {
                System.setProperty("kie.maven.settings.custom", oldSettingsXmlPath);
            }
            MavenSettings.reinitSettings();
        }
    }

    @Test
    public void testCustomSettingSource() {
        try {
            MavenRequest mavenRequest = MavenEmbedderTest.createMavenRequest(new SettingsSourceMock("<settings/>"));
            MavenEmbedderWithRepoMock embedder = new MavenEmbedderWithRepoMock(mavenRequest);
            MavenExecutionRequest request = embedder.getMavenExecutionRequest();
            Assert.assertNotNull((Object)request);
            Assert.assertEquals((Object)"<settings/>", (Object)MavenEmbedderTest.readFileAsString(request.getUserSettingsFile()).trim());
        }
        catch (MavenEmbedderException mee) {
            Assert.fail((String)mee.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxies() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            if (oldSettingsXmlPath != null) {
                System.clearProperty("kie.maven.settings.custom");
            }
            MavenSettings.reinitSettingsFromString((String)"<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\"/>\n");
            MavenRequest mavenRequest = MavenEmbedderTest.createMavenRequest(null);
            MavenEmbedderWithProxyMock embedder = new MavenEmbedderWithProxyMock(mavenRequest);
            MavenExecutionRequest request = embedder.getMavenExecutionRequest();
            Assert.assertNotNull((Object)request);
            List proxies = request.getProxies();
            Assert.assertEquals((long)1L, (long)proxies.size());
            Assert.assertEquals((Object)"MyProxy", (Object)((Proxy)proxies.get(0)).getId());
        }
        catch (MavenEmbedderException mee) {
            Assert.fail((String)mee.getMessage());
        }
        finally {
            if (oldSettingsXmlPath != null) {
                System.setProperty("kie.maven.settings.custom", oldSettingsXmlPath);
            }
            MavenSettings.reinitSettings();
        }
    }

    private static MavenRequest createMavenRequest(SettingsSource settingsSource) {
        MavenRequest mavenRequest = new MavenRequest();
        mavenRequest.setLocalRepositoryPath(MavenSettings.getSettings().getLocalRepository());
        mavenRequest.setUserSettingsSource(settingsSource != null ? settingsSource : MavenSettings.getUserSettingsSource());
        mavenRequest.setResolveDependencies(true);
        mavenRequest.setOffline(true);
        return mavenRequest;
    }

    private static String readFileAsString(File file) {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static class SettingsSourceMock
    implements SettingsSource {
        private final String settings;

        public SettingsSourceMock(String settings) {
            this.settings = settings;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.settings.getBytes("UTF-8"));
        }

        public String getLocation() {
            return "test";
        }
    }

    public static class MavenEmbedderWithProxyMock
    extends MavenEmbedderMock {
        public MavenEmbedderWithProxyMock(MavenRequest mavenRequest) throws MavenEmbedderException {
            super(mavenRequest);
        }

        @Override
        protected String getSettingsFile() {
            return "settings_with_proxies.xml";
        }
    }

    public static class MavenEmbedderWithRepoMock
    extends MavenEmbedderMock {
        public MavenEmbedderWithRepoMock(MavenRequest mavenRequest) throws MavenEmbedderException {
            super(mavenRequest);
        }

        @Override
        protected String getSettingsFile() {
            return "settings_with_repositories.xml";
        }
    }

    public static abstract class MavenEmbedderMock
    extends MavenEmbedder {
        public MavenEmbedderMock(MavenRequest mavenRequest) throws MavenEmbedderException {
            super(mavenRequest);
        }

        protected MavenRepositoryConfiguration getMavenRepositoryConfiguration() {
            return new MavenRepositoryConfiguration(this.getMavenSettings());
        }

        private Settings getMavenSettings() {
            String path = ((Object)((Object)this)).getClass().getResource(".").toString().substring("file:".length());
            File testSettingsFile = new File(path + this.getSettingsFile());
            Assert.assertTrue((boolean)testSettingsFile.exists());
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(testSettingsFile);
            try {
                return settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
            }
            catch (SettingsBuildingException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract String getSettingsFile();
    }
}

