/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.appformer.maven.integration.Aether;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.integration.MavenRepositoryConfiguration;
import org.eclipse.aether.repository.RemoteRepository;
import org.junit.Assert;
import org.junit.Test;

public class MavenRepositoryTest {
    @Test
    public void testMirrors() {
        MavenRepositoryMock.setCustomSettingsFileName("settings_with_mirror.xml");
        MavenRepositoryMock repo = new MavenRepositoryMock(Aether.getAether());
        Collection remoteRepos = repo.getRemoteRepositoriesForRequest();
        Assert.assertEquals((long)2L, (long)remoteRepos.size());
        for (RemoteRepository remoteRepo : remoteRepos) {
            Assert.assertTrue((remoteRepo.getId().equals("qa") || remoteRepo.getId().equals("foo") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testProxy() {
        MavenRepositoryMock.setCustomSettingsFileName("settings_custom.xml");
        MavenRepositoryMock repo = new MavenRepositoryMock(Aether.getAether());
        Collection remoteRepos = repo.getRemoteRepositoriesForRequest();
        Set testServerRepos = remoteRepos.stream().filter(r -> r.getId().equals("test-server")).collect(Collectors.toSet());
        Assert.assertEquals((long)2L, (long)testServerRepos.size());
        for (RemoteRepository remoteRepository : testServerRepos) {
            Assert.assertNotNull((Object)remoteRepository.getProxy());
        }
    }

    public static class MavenRepositoryMock
    extends MavenRepository {
        private static String customSettingsFileName;

        public static void setCustomSettingsFileName(String customSettingsFileNameParam) {
            customSettingsFileName = customSettingsFileNameParam;
        }

        protected MavenRepositoryMock(Aether aether) {
            super(aether);
        }

        protected MavenRepositoryConfiguration getMavenRepositoryConfiguration() {
            return new MavenRepositoryConfiguration(this.getMavenSettings());
        }

        private Settings getMavenSettings() {
            String path = ((Object)((Object)this)).getClass().getResource(".").toString().substring("file:".length());
            File testSettingsFile = new File(path + customSettingsFileName);
            Assert.assertTrue((boolean)testSettingsFile.exists());
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(testSettingsFile);
            try {
                return settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
            }
            catch (SettingsBuildingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

