/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.Aether;
import org.appformer.maven.integration.IoUtils;
import org.appformer.maven.integration.S3WagonMock;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.assertj.core.api.Assertions;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AetherTest {
    private final String SETTINGS_WITH_PROXY = "<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\">  <proxies>\n    <proxy>\n      <id>MyProxy</id>\n      <active>true</active>\n      <protocol>http</protocol>\n      <host>localhost</host>\n      <port>8888</port>\n    </proxy>\n  </proxies></settings>\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxies() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            if (oldSettingsXmlPath != null) {
                System.clearProperty("kie.maven.settings.custom");
            }
            MavenSettings.reinitSettingsFromString((String)"<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\">  <proxies>\n    <proxy>\n      <id>MyProxy</id>\n      <active>true</active>\n      <protocol>http</protocol>\n      <host>localhost</host>\n      <port>8888</port>\n    </proxy>\n  </proxies></settings>\n");
            Aether aether = Aether.getAether();
            RemoteRepository remoteRepository = new RemoteRepository.Builder("local", "default", "http://myserver.com").build();
            Proxy proxy = aether.getSession().getProxySelector().getProxy(remoteRepository);
            Assert.assertEquals((Object)"http", (Object)proxy.getType());
            Assert.assertEquals((Object)"localhost", (Object)proxy.getHost());
            Assert.assertEquals((long)8888L, (long)proxy.getPort());
        }
        finally {
            if (oldSettingsXmlPath != null) {
                System.setProperty("kie.maven.settings.custom", oldSettingsXmlPath);
            }
            MavenSettings.reinitSettings();
        }
    }

    @Test
    public void testForcedOffline() {
        RemoteRepository central = new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2/").build();
        MavenProject mavenProject = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mavenProject.getRemoteProjectRepositories()).thenReturn(Collections.singletonList(central));
        Aether aether = new Aether(mavenProject){

            boolean isForcedOffline() {
                return true;
            }
        };
        Assertions.assertThat((Iterable)aether.getRepositories()).doesNotContain((Object[])new RemoteRepository[]{central});
    }

    @Test
    public void testNotOffline() {
        RemoteRepository central = new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2/").build();
        MavenProject mavenProject = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mavenProject.getRemoteProjectRepositories()).thenReturn(Collections.singletonList(central));
        Aether aether = new Aether(mavenProject){

            boolean isForcedOffline() {
                return false;
            }
        };
        Assertions.assertThat((Iterable)aether.getRepositories()).contains((Object[])new RemoteRepository[]{central});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseWagonClass() throws ArtifactResolutionException {
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy(true, "never", "ignore");
        RemoteRepository s3repository = new RemoteRepository.Builder("central", "default", "s3://amazon-s3-repository-bucket/").setPolicy(repositoryPolicy).build();
        List<RemoteRepository> remoteRepositories = Collections.singletonList(s3repository);
        MavenProject mavenProject = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mavenProject.getRemoteProjectRepositories()).thenReturn(remoteRepositories);
        ArtifactRequest request = new ArtifactRequest((Artifact)new DefaultArtifact("org.test:fake:0.0.1"), remoteRepositories, null);
        try {
            System.setProperty("kie.maven.s3.wagon.class", "org.appformer.maven.integration.S3WagonMock");
            File tmpDirectory = IoUtils.getTmpDirectory();
            MavenSettings.getSettings().setLocalRepository(tmpDirectory.getAbsolutePath());
            Aether aether = new Aether(mavenProject);
            RepositorySystemSession session = aether.getSession();
            ArtifactResult artifactResult = aether.getSystem().resolveArtifact(session, request);
            Assert.assertTrue((boolean)artifactResult.isResolved());
            Assert.assertTrue((boolean)S3WagonMock.wasUsed());
        }
        finally {
            System.clearProperty("kie.maven.s3.wagon.class");
            MavenSettings.reinitSettings();
        }
    }

    @Test
    public void shouldThrowExceptionWhenWagonClassNotFound() {
        this.shouldThrowExceptionForWagonClass("com.acme.fake.s3wagon.class");
    }

    @Test
    public void shouldThrowExceptionWhenWagonClassWasNotProvided() {
        this.shouldThrowExceptionForWagonClass("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldThrowExceptionForWagonClass(String s3WagonClass) {
        RemoteRepository s3repository = new RemoteRepository.Builder("central", "default", "s3://amazon-s3-repository-bucket/").build();
        List<RemoteRepository> remoteRepositories = Collections.singletonList(s3repository);
        MavenProject mavenProject = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mavenProject.getRemoteProjectRepositories()).thenReturn(remoteRepositories);
        ArtifactRequest request = new ArtifactRequest((Artifact)new DefaultArtifact("org.test:fake:0.0.1"), remoteRepositories, null);
        try {
            System.setProperty("kie.maven.s3.wagon.class", s3WagonClass);
            Aether aether = new Aether(mavenProject);
            RepositorySystemSession session = aether.getSession();
            Assertions.assertThatCode(() -> aether.getSystem().resolveArtifact(session, request)).hasCauseInstanceOf(ArtifactTransferException.class);
        }
        finally {
            System.clearProperty("kie.maven.s3.wagon.class");
        }
    }
}

