/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration.embedder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.Aether;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MavenProjectLoaderTest {
    private static final String VERSION = "1.0-SNAPSHOT";
    private static final String ARTIFACT_ID = "myArtifactId";
    private static final String GROUP_ID = "myGroupId";
    protected static final String PROJ = "    <project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n      <modelVersion>4.0.0</modelVersion>\n     \n      <groupId>myGroupId</groupId>\n      <artifactId>myArtifactId2</artifactId>\n      <version>1.0-SNAPSHOT</version>\n      <dependencies>          <dependency>             <groupId>myGroupId</groupId>\n              <artifactId>myArtifactId</artifactId>              <version>1.0-SNAPSHOT</version>          </dependency>      </dependencies>    </project>";

    @BeforeClass
    public static void installDependency() throws InstallationException {
        String repoRoot = MavenProjectLoaderTest.class.getResource("/").getFile();
        MavenSettings.reinitSettingsFromString((String)MavenProjectLoaderTest.settings(repoRoot));
        String jarURL = MavenProjectLoaderTest.class.getResource("/assets/myArtifactId").getFile();
        DefaultArtifact artifact = new DefaultArtifact(GROUP_ID, ARTIFACT_ID, "", "jar", VERSION, Collections.emptyMap(), new File(jarURL));
        InstallRequest request = new InstallRequest().addArtifact((Artifact)artifact);
        RepositorySystemSession session = Aether.getAether().getSession();
        Aether.getAether().getSystem().install(session, request);
    }

    @Test
    public void shouldAddDependencyArtifactsTest() throws Exception {
        MavenProjectLoader.IS_FORCE_OFFLINE = true;
        ByteArrayInputStream targetPom = new ByteArrayInputStream(PROJ.getBytes(StandardCharsets.UTF_8));
        MavenProject mavenProj = MavenProjectLoader.parseMavenPom((InputStream)targetPom, (boolean)true);
        Assert.assertEquals((long)1L, (long)mavenProj.getArtifacts().size());
        org.apache.maven.artifact.Artifact dependencyArtifact = (org.apache.maven.artifact.Artifact)mavenProj.getArtifacts().iterator().next();
        Assert.assertEquals((Object)ARTIFACT_ID, (Object)dependencyArtifact.getArtifactId());
        Assert.assertEquals((Object)GROUP_ID, (Object)dependencyArtifact.getGroupId());
        Assert.assertEquals((Object)VERSION, (Object)dependencyArtifact.getVersion());
    }

    static String settings(String localRepo) {
        return "<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\">\n     <localRepository>" + localRepo + "</localRepository></settings>";
    }
}

