/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import junit.framework.TestCase;
import org.appformer.maven.integration.InJarArtifactResolver;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ArtifactResolverTest
extends TestCase {
    public void testInJarResolverSnapshotLocal() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        AFReleaseIdImpl releaseId = new AFReleaseIdImpl("org.jbpm", "kjar", "1.0.0-SNAPSHOT", "jar");
        ArrayList<URL> urlArrayList = new ArrayList<URL>();
        urlArrayList.add(classLoader.getResource("BOOT-INF/classes/KIE-INF/lib/kjar-1.0.0-SNAPSHOT.pom"));
        InJarArtifactResolver inJarArtifactResolver = new InJarArtifactResolver(classLoader, (AFReleaseId)releaseId);
        InJarArtifactResolver spy = (InJarArtifactResolver)Mockito.spy((Object)inJarArtifactResolver);
        ((InJarArtifactResolver)Mockito.doReturn(urlArrayList).when((Object)spy)).buildResources((Predicate)ArgumentMatchers.any());
        spy.init();
        ((InJarArtifactResolver)Mockito.verify((Object)spy)).getURL(Mockito.endsWith((String)"BOOT-INF/classes/KIE-INF/lib/kjar-1.0.0-SNAPSHOT.pom"));
    }

    public void testInJarResolverSnapshotExternal() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        AFReleaseIdImpl releaseId = new AFReleaseIdImpl("org.jbpm", "kjar", "1.0.0-SNAPSHOT", "jar");
        InJarArtifactResolver inJarArtifactResolver = new InJarArtifactResolver(classLoader, (AFReleaseId)releaseId);
        InJarArtifactResolver spy = (InJarArtifactResolver)Mockito.spy((Object)inJarArtifactResolver);
        ArrayList<URL> urlArrayList = new ArrayList<URL>();
        urlArrayList.add(classLoader.getResource("BOOT-INF/classes/KIE-INF/lib/kjar-1.0.0-20240717-143315-1.pom"));
        ((InJarArtifactResolver)Mockito.doReturn(urlArrayList).when((Object)spy)).buildResources((Predicate)ArgumentMatchers.any());
        spy.init();
        ((InJarArtifactResolver)Mockito.verify((Object)spy)).getURL(Mockito.endsWith((String)"BOOT-INF/classes/KIE-INF/lib/kjar-1.0.0-20240717-143315-1.pom"));
    }

    class MyInJarArtifactResolver
    extends InJarArtifactResolver {
        MyInJarArtifactResolver(ClassLoader classLoader, AFReleaseId releaseId) {
            super(classLoader, releaseId);
        }

        protected Optional<URL> tryInStructuredJar(AFReleaseId releaseId) {
            return super.tryInStructuredJar(releaseId);
        }
    }
}

