/*
 * Decompiled with CFR 0.152.
 */
package org.kie.soup.project.datamodel.oracle;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.soup.project.datamodel.oracle.DataType;

@RunWith(value=Parameterized.class)
public class DataTypeTest {
    @Parameterized.Parameter(value=0)
    public String dataType;
    @Parameterized.Parameter(value=1)
    public boolean isNumeric;
    @Parameterized.Parameter(value=2)
    public boolean isDate;

    @Parameterized.Parameters(name="Type={0}, isNumeric={1}, isDate={2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Numeric", true, false}, {"Byte", true, false}, {"Short", true, false}, {"Integer", true, false}, {"Long", true, false}, {"BigInteger", true, false}, {"Float", true, false}, {"Double", true, false}, {"BigDecimal", true, false}, {"Boolean", false, false}, {"Collection", false, false}, {"Comparable", false, false}, {"Date", false, true}, {"LocalDate", false, true}, {"LocalDateTime", false, true}, {"FinalObject", false, false}, {"Object", false, false}, {"String", false, false}, {"this", false, false}, {"void", false, false});
    }

    @Test
    public void testIsNumeric() {
        Assertions.assertThat((boolean)DataType.isNumeric((String)this.dataType)).isEqualTo(this.isNumeric);
    }

    @Test
    public void testIsDate() {
        Assertions.assertThat((boolean)DataType.isDate((String)this.dataType)).isEqualTo(this.isDate);
    }
}

