/*
 * Decompiled with CFR 0.152.
 */
package org.kie.soup.project.datamodel.commons.packages;

import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.project.datamodel.commons.packages.PackageNameWriter;
import org.kie.soup.project.datamodel.packages.HasPackageName;

public class PackageNameWriterTest {
    @Test
    public void testNullModel() {
        HasPackageName model = new HasPackageName(){
            private String packageName = null;

            public String getPackageName() {
                return this.packageName;
            }

            public void setPackageName(String packageName) {
                this.packageName = packageName;
            }
        };
        StringBuilder sb = new StringBuilder();
        PackageNameWriter.write((StringBuilder)sb, (HasPackageName)model);
        String drl = sb.toString();
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((boolean)drl.isEmpty());
    }

    @Test
    public void testEmptyModel() {
        HasPackageName model = new HasPackageName(){
            private String packageName = "";

            public String getPackageName() {
                return this.packageName;
            }

            public void setPackageName(String packageName) {
                this.packageName = packageName;
            }
        };
        StringBuilder sb = new StringBuilder();
        PackageNameWriter.write((StringBuilder)sb, (HasPackageName)model);
        String drl = sb.toString();
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((boolean)drl.isEmpty());
    }

    @Test
    public void testModel() {
        String expectedDrl = "package org.drools.guvnor.models.commons.backend.packages;\n\n";
        HasPackageName model = new HasPackageName(){
            private String packageName = "org.drools.guvnor.models.commons.backend.packages";

            public String getPackageName() {
                return this.packageName;
            }

            public void setPackageName(String packageName) {
                this.packageName = packageName;
            }
        };
        StringBuilder sb = new StringBuilder();
        PackageNameWriter.write((StringBuilder)sb, (HasPackageName)model);
        String drl = sb.toString();
        Assert.assertNotNull((Object)drl);
        Assert.assertEquals((Object)"package org.drools.guvnor.models.commons.backend.packages;\n\n", (Object)drl);
    }
}

