/*
 * Decompiled with CFR 0.152.
 */
package org.kie.soup.project.datamodel.commons.packages;

import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.project.datamodel.commons.packages.PackageNameParser;

public class PackageNameParserTest {
    @Test
    public void testNullContent() {
        String content = null;
        String packageName = PackageNameParser.parsePackageName(content);
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"", (Object)packageName);
    }

    @Test
    public void testEmptyContent() {
        String content = "";
        String packageName = PackageNameParser.parsePackageName((String)"");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"", (Object)packageName);
    }

    @Test
    public void testCommentedContent() {
        String content = "#This is a comment";
        String packageName = PackageNameParser.parsePackageName((String)"#This is a comment");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"", (Object)packageName);
    }

    @Test
    public void testSinglePackageDeclarationContent() {
        String content = "package org.drools.guvnor.models.commons.backend.packages;";
        String packageName = PackageNameParser.parsePackageName((String)"package org.drools.guvnor.models.commons.backend.packages;");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"org.drools.guvnor.models.commons.backend.packages", (Object)packageName);
    }

    @Test
    public void testMultiplePackageDeclarationsContent() {
        String content = "package org.drools.guvnor.models.commons.backend.packages;\npackage a.second.package.declaration;\n";
        String packageName = PackageNameParser.parsePackageName((String)"package org.drools.guvnor.models.commons.backend.packages;\npackage a.second.package.declaration;\n");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"org.drools.guvnor.models.commons.backend.packages", (Object)packageName);
    }

    @Test
    public void testMixedContent() {
        String content = "package org.drools.guvnor.models.commons.backend.packages;\n#This is a comment\npackage a.second.package.declaration;\n\npackage a.third.package.declaration;\n";
        String packageName = PackageNameParser.parsePackageName((String)"package org.drools.guvnor.models.commons.backend.packages;\n#This is a comment\npackage a.second.package.declaration;\n\npackage a.third.package.declaration;\n");
        Assert.assertNotNull((Object)packageName);
        Assert.assertEquals((Object)"org.drools.guvnor.models.commons.backend.packages", (Object)packageName);
    }
}

