/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.apps.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.uberfire.apps.api.AppsPersistenceAPI;
import org.kie.uberfire.apps.api.Directory;
import org.kie.uberfire.perspective.editor.PerspectiveEditorPersistence;
import org.kie.uberfire.perspective.editor.model.PerspectiveEditor;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;

@Service
@ApplicationScoped
public class AppsPersistenceImpl
implements AppsPersistenceAPI {
    public static final String HOME_DIR = "Home";
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    PerspectiveEditorPersistence perspectiveEditorPersistence;

    @PostConstruct
    public void setup() {
    }

    public Directory getRootDirectory() {
        Map<String, List<String>> tagMap = this.generateTagMap();
        Directory root = this.buildDirectories(tagMap);
        return root;
    }

    private Map<String, List<String>> generateTagMap() {
        HashMap<String, List<String>> tagsMap = new HashMap<String, List<String>>();
        List perspectiveEditors = this.perspectiveEditorPersistence.loadAll();
        for (PerspectiveEditor perspectiveEditor : perspectiveEditors) {
            for (String tag : perspectiveEditor.getTags()) {
                ArrayList<String> perspectives = (ArrayList<String>)tagsMap.get(tag.toUpperCase());
                if (perspectives == null) {
                    perspectives = new ArrayList<String>();
                }
                perspectives.add(perspectiveEditor.getName());
                tagsMap.put(tag.toUpperCase(), perspectives);
            }
        }
        return tagsMap;
    }

    private Directory buildDirectories(Map<String, List<String>> tagMap) {
        Path homeDir = this.getHomeDir();
        Directory root = new Directory(homeDir.getFileName().toString(), homeDir.toString(), homeDir.toUri().toString(), tagMap);
        root.addChildDirectories(this.extractAllChildDirectories(root, homeDir));
        return root;
    }

    private List<Directory> extractAllChildDirectories(Directory parent, Path dir) {
        ArrayList<Directory> childs = new ArrayList<Directory>();
        if (this.ioService.exists(dir) && Files.isDirectory((Path)dir, (LinkOption[])new LinkOption[0])) {
            DirectoryStream paths = this.ioService.newDirectoryStream(dir);
            for (Path childPath : paths) {
                if (!Files.isDirectory((Path)childPath, (LinkOption[])new LinkOption[0])) continue;
                Directory child = this.getDirectory(childPath.getFileName().toString(), childPath.toString(), childPath.toUri().toString(), parent);
                List<Directory> childsOfChilds = this.extractAllChildDirectories(child, childPath);
                child.addChildDirectories(childsOfChilds);
                childs.add(child);
            }
        }
        return childs;
    }

    private Directory getDirectory(String name, String fullpath, String uri, Directory parent) {
        return new Directory(name, fullpath, uri, parent);
    }

    public Directory createDirectory(Directory parentDirectory, String name) {
        Path parentDir = this.recursiveSearchForDir(this.getHomeDir(), parentDirectory);
        Path newDir = parentDir.resolve(name);
        if (!this.ioService.exists(newDir)) {
            this.createDir(newDir);
        }
        newDir = this.ioService.get(newDir.toUri());
        return this.getDirectory(name, newDir.toString(), newDir.toUri().toString(), parentDirectory);
    }

    public Boolean deleteDirectory(String uri) {
        Path dir = this.ioService.get(uri, new String[0]);
        return this.ioService.deleteIfExists(dir, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES});
    }

    private Path recursiveSearchForDir(Path dir, Directory parentDirectory) {
        if (this.ioService.exists(dir) && Files.isDirectory((Path)dir, (LinkOption[])new LinkOption[0])) {
            if (this.isThisPathRelativeToThisDir(dir, parentDirectory)) {
                return dir;
            }
            Path desiredPath = null;
            DirectoryStream paths = this.ioService.newDirectoryStream(dir);
            for (Path path : paths) {
                if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                    desiredPath = this.recursiveSearchForDir(path, parentDirectory);
                }
                if (desiredPath == null) continue;
                break;
            }
            return desiredPath;
        }
        return null;
    }

    private boolean isThisPathRelativeToThisDir(Path dir, Directory parentDirectory) {
        return dir.getFileName().toString().equals(parentDirectory.getName());
    }

    private Path getHomeDir() {
        Path homeDir = this.fileSystem.getPath(HOME_DIR, new String[0]);
        if (!this.ioService.exists(homeDir)) {
            this.createDir(homeDir);
        }
        return homeDir;
    }

    private void createDir(Path dir) {
        Path dummy_file = dir.resolve("dummy_file");
        this.ioService.write(dummy_file, ".", new OpenOption[0]);
    }
}

