/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.metadata.backend.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.kie.uberfire.metadata.backend.lucene.index.LuceneIndex;
import org.kie.uberfire.metadata.backend.lucene.index.LuceneIndexFactory;
import org.kie.uberfire.metadata.backend.lucene.model.KClusterImpl;
import org.kie.uberfire.metadata.engine.Index;
import org.kie.uberfire.metadata.engine.IndexManager;
import org.kie.uberfire.metadata.model.KCluster;
import org.kie.uberfire.metadata.model.KObjectKey;
import org.kie.uberfire.metadata.search.ClusterSegment;
import org.uberfire.commons.validation.Preconditions;

public class LuceneIndexManager
implements IndexManager {
    private final LuceneIndexFactory factory;
    private final Map<KCluster, LuceneIndex> indexes = new HashMap<KCluster, LuceneIndex>();

    public LuceneIndexManager(LuceneIndexFactory factory) {
        this.factory = (LuceneIndexFactory)Preconditions.checkNotNull((String)"factory", (Object)factory);
        this.indexes.putAll(factory.getIndexes());
    }

    public boolean contains(KCluster cluster) {
        return this.indexes.containsKey(cluster);
    }

    public synchronized LuceneIndex indexOf(KObjectKey object) {
        KCluster kcluster = this.kcluster(object);
        LuceneIndex currentSetup = this.indexes.get(kcluster);
        if (currentSetup != null) {
            return currentSetup;
        }
        LuceneIndex index = this.factory.newCluster(kcluster);
        this.indexes.put(kcluster, index);
        return index;
    }

    public KCluster kcluster(KObjectKey object) {
        return new KClusterImpl(object.getClusterId());
    }

    public void delete(KCluster cluster) {
        LuceneIndex setup = this.indexes.remove(cluster);
        this.factory.remove(cluster);
        if (setup != null) {
            setup.delete();
        }
    }

    public void dispose() {
        for (LuceneIndex index : this.indexes.values()) {
            index.dispose();
        }
        this.factory.dispose();
    }

    public Index get(KCluster cluster) {
        return this.indexes.get(cluster);
    }

    /*
     * WARNING - void declaration
     */
    public IndexSearcher getIndexSearcher(ClusterSegment ... clusterSegments) {
        HashSet<Object> clusters;
        if (clusterSegments == null || clusterSegments.length == 0) {
            clusters = new HashSet<KCluster>(this.indexes.keySet());
        } else {
            void var5_8;
            clusters = new HashSet(clusterSegments.length);
            ClusterSegment[] arr$ = clusterSegments;
            int len$ = arr$.length;
            boolean bl = false;
            while (var5_8 < len$) {
                ClusterSegment clusterSegment = arr$[var5_8];
                clusters.add(new KClusterImpl(clusterSegment.getClusterId()));
                ++var5_8;
            }
        }
        ArrayList<IndexReader> readers = new ArrayList<IndexReader>(clusters.size());
        for (KCluster kCluster : clusters) {
            LuceneIndex index = this.indexes.get(kCluster);
            readers.add(index.nrtReader());
        }
        try {
            return new SearcherFactory().newSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[readers.size()])));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void release(IndexSearcher index) {
        try {
            index.getIndexReader().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

