/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.social.activities.model;

import org.junit.Assert;
import org.junit.Test;
import org.kie.uberfire.social.activities.model.SocialUser;

public class SocialUserTest {
    @Test
    public void userCannotFollowHimself() {
        SocialUser user1 = new SocialUser("user1");
        user1.follow(user1);
        Assert.assertTrue((boolean)user1.getFollowersName().isEmpty());
        Assert.assertTrue((boolean)user1.getFollowingName().isEmpty());
    }

    @Test
    public void followBasicTest() {
        SocialUser user1 = new SocialUser("user1");
        SocialUser user2 = new SocialUser("user2");
        user1.follow(user2);
        Assert.assertTrue((boolean)user1.getFollowingName().contains(user2.getUserName()));
        Assert.assertTrue((boolean)user2.getFollowersName().contains(user1.getUserName()));
    }

    @Test
    public void unfollowTest() {
        SocialUser user1 = new SocialUser("user1");
        SocialUser user2 = new SocialUser("user2");
        user1.follow(user2);
        Assert.assertTrue((boolean)user1.getFollowingName().contains(user2.getUserName()));
        Assert.assertTrue((boolean)user2.getFollowersName().contains(user1.getUserName()));
        user1.unfollow(user2);
        Assert.assertTrue((boolean)user1.getFollowingName().isEmpty());
        Assert.assertTrue((boolean)user2.getFollowersName().isEmpty());
    }
}

