/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.properties.editor.model;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.kie.uberfire.properties.editor.model.PropertyEditorCategory;
import org.kie.uberfire.properties.editor.model.PropertyEditorEvent;
import org.kie.uberfire.properties.editor.model.PropertyEditorFieldInfo;
import org.kie.uberfire.properties.editor.model.PropertyEditorType;

public class PropertyEditorEventTest {
    @Test
    public void sortCategoryByPriority() {
        ArrayList<PropertyEditorCategory> categories = new ArrayList<PropertyEditorCategory>();
        PropertyEditorCategory category1 = new PropertyEditorCategory("cat1", 2);
        categories.add(category1);
        PropertyEditorCategory category2 = new PropertyEditorCategory("catHighPriority", 1);
        categories.add(category2);
        PropertyEditorEvent event = new PropertyEditorEvent("event", categories);
        Assert.assertEquals((Object)category2, event.getSortedProperties().get(0));
        Assert.assertEquals((Object)category1, event.getSortedProperties().get(1));
    }

    @Test
    public void sortFieldsByPriority() {
        PropertyEditorFieldInfo highPriority = new PropertyEditorFieldInfo("highPriority", PropertyEditorType.BOOLEAN).withPriority(1);
        PropertyEditorFieldInfo lowPriority = new PropertyEditorFieldInfo("lowPriority", PropertyEditorType.BOOLEAN).withPriority(10);
        PropertyEditorCategory category = new PropertyEditorCategory("cat1", 2).withField(lowPriority).withField(highPriority);
        PropertyEditorEvent event = new PropertyEditorEvent("event", category);
        Assert.assertEquals((Object)highPriority, ((PropertyEditorCategory)event.getSortedProperties().get(0)).getFields().get(0));
        Assert.assertEquals((Object)lowPriority, ((PropertyEditorCategory)event.getSortedProperties().get(0)).getFields().get(1));
    }
}

