/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.properties.editor.server;

import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.uberfire.properties.editor.model.PropertyEditorCategory;
import org.kie.uberfire.properties.editor.model.PropertyEditorFieldInfo;
import org.kie.uberfire.properties.editor.model.PropertyEditorType;
import org.kie.uberfire.properties.editor.service.BeanPropertyEditorBuilderService;

@Service
@Dependent
public class BeanPropertyEditorBuilder
implements BeanPropertyEditorBuilderService {
    public PropertyEditorCategory extract(String fqcn) {
        return this.extractOnlyBeanInfo(fqcn);
    }

    public PropertyEditorCategory extract(String fqcn, Object instance) {
        return this.extractBeanInfoAndValues(fqcn, instance);
    }

    private PropertyEditorCategory extractOnlyBeanInfo(String fqcn) {
        return this.extractBeanInfoAndValues(fqcn, null);
    }

    private PropertyEditorCategory extractBeanInfoAndValues(String fqcn, Object instance) {
        Class<?> targetClass;
        try {
            targetClass = Class.forName(fqcn);
        }
        catch (Exception e) {
            throw new NullBeanException();
        }
        PropertyEditorCategory beanCategory = new PropertyEditorCategory(targetClass.getSimpleName());
        this.extractFieldInformationAndValues(targetClass, beanCategory, instance);
        return beanCategory;
    }

    private void extractFieldInformationAndValues(Class targetClass, PropertyEditorCategory beanCategory, Object instance) throws ErrorReadingFieldInformationAndValues {
        for (Field declaredField : targetClass.getDeclaredFields()) {
            PropertyEditorType type = PropertyEditorType.getFromType(declaredField.getType());
            if (!this.isAHandledType(type)) continue;
            PropertyEditorFieldInfo field = this.createPropertyEditorInfo(instance, declaredField, type);
            if (this.isACombo(field)) {
                this.generateComboValues(declaredField, field);
            }
            beanCategory.withField(field);
        }
    }

    private PropertyEditorFieldInfo createPropertyEditorInfo(Object instance, Field declaredField, PropertyEditorType type) {
        if (this.needToExtractValues(instance)) {
            return new PropertyEditorFieldInfo(declaredField.getName(), this.extractFieldValue(instance, declaredField), type);
        }
        return new PropertyEditorFieldInfo(declaredField.getName(), type);
    }

    private boolean needToExtractValues(Object instance) {
        return instance != null;
    }

    private boolean isACombo(PropertyEditorFieldInfo field) {
        return field.getType().equals((Object)PropertyEditorType.COMBO);
    }

    private String extractFieldValue(Object instance, Field field) {
        try {
            return this.extractStringValue(instance, field);
        }
        catch (IllegalAccessException e) {
            throw new ErrorReadingFieldInformationAndValues();
        }
    }

    private String extractStringValue(Object instance, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        Object value = field.get(instance);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    private void generateComboValues(Field declaredField, PropertyEditorFieldInfo field) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object constant : declaredField.getType().getEnumConstants()) {
            values.add(constant.toString());
        }
        field.withComboValues(values);
    }

    public boolean isAHandledType(PropertyEditorType type) {
        return type != null;
    }

    private class ErrorReadingFieldInformationAndValues
    extends RuntimeException {
        private ErrorReadingFieldInformationAndValues() {
        }
    }

    public class NullBeanException
    extends RuntimeException {
    }
}

