/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.properties.editor.client;

import com.github.gwtbootstrap.client.ui.Accordion;
import com.github.gwtbootstrap.client.ui.AccordionGroup;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.uberfire.properties.editor.client.PropertyEditorHelper;
import org.kie.uberfire.properties.editor.client.PropertyEditorItemWidget;
import org.kie.uberfire.properties.editor.client.PropertyEditorWidget;
import org.kie.uberfire.properties.editor.client.widgets.PropertyEditorErrorWidget;
import org.kie.uberfire.properties.editor.client.widgets.PropertyEditorItemLabel;
import org.kie.uberfire.properties.editor.client.widgets.PropertyEditorItemsWidget;
import org.kie.uberfire.properties.editor.client.widgets.PropertyEditorTextBox;
import org.kie.uberfire.properties.editor.model.PropertyEditorCategory;
import org.kie.uberfire.properties.editor.model.PropertyEditorEvent;
import org.kie.uberfire.properties.editor.model.PropertyEditorFieldInfo;
import org.kie.uberfire.properties.editor.model.PropertyEditorType;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class PropertyEditorHelperTest {
    @Test(expected=PropertyEditorHelper.NullEventException.class)
    public void validateNullEventTest() {
        PropertyEditorHelper.validade(null);
    }

    @Test(expected=PropertyEditorHelper.NoPropertiesException.class)
    public void validateEventWithNoPropertiesTest() {
        PropertyEditorEvent event = new PropertyEditorEvent("id", new ArrayList());
        PropertyEditorHelper.validade((PropertyEditorEvent)event);
    }

    @Test
    public void validateEventTest() {
        ArrayList<PropertyEditorCategory> properties = new ArrayList<PropertyEditorCategory>();
        properties.add(new PropertyEditorCategory("Category"));
        PropertyEditorEvent event = new PropertyEditorEvent("id", properties);
        Assert.assertTrue((boolean)PropertyEditorHelper.validade((PropertyEditorEvent)event));
    }

    @Test
    public void isAMatchOfEmptyFilterTest() {
        PropertyEditorFieldInfo field = new PropertyEditorFieldInfo();
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"", (PropertyEditorFieldInfo)field));
    }

    @Test
    public void isAMatchOfFilterTest() {
        PropertyEditorFieldInfo field = new PropertyEditorFieldInfo("label", PropertyEditorType.TEXT);
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"l", (PropertyEditorFieldInfo)field));
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"label", (PropertyEditorFieldInfo)field));
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"LABEL", (PropertyEditorFieldInfo)field));
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"abel", (PropertyEditorFieldInfo)field));
        Assert.assertFalse((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"LABELL", (PropertyEditorFieldInfo)field));
        Assert.assertFalse((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"LASBELL", (PropertyEditorFieldInfo)field));
        Assert.assertFalse((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"p", (PropertyEditorFieldInfo)field));
    }

    @Test
    public void createLabelTest() {
        PropertyEditorFieldInfo field = new PropertyEditorFieldInfo("label", PropertyEditorType.TEXT);
        PropertyEditorItemLabel label = PropertyEditorHelper.createLabel((PropertyEditorFieldInfo)field);
        ((PropertyEditorItemLabel)Mockito.verify((Object)label)).setText("label");
    }

    @Test
    public void createErrorHandlingInfraStructureTest() {
        PropertyEditorTextBox widget = (PropertyEditorTextBox)GWT.create(PropertyEditorTextBox.class);
        PropertyEditorItemWidget itemWidget = (PropertyEditorItemWidget)GWT.create(PropertyEditorItemWidget.class);
        PropertyEditorItemsWidget parent = (PropertyEditorItemsWidget)GWT.create(PropertyEditorItemsWidget.class);
        PropertyEditorErrorWidget errorWidget = (PropertyEditorErrorWidget)GWT.create(PropertyEditorErrorWidget.class);
        PropertyEditorHelper.createErrorHandlingInfraStructure((PropertyEditorItemsWidget)parent, (PropertyEditorItemWidget)itemWidget, (PropertyEditorErrorWidget)errorWidget, (Widget)widget);
        ((PropertyEditorTextBox)Mockito.verify((Object)widget)).setErrorWidget(errorWidget);
        ((PropertyEditorTextBox)Mockito.verify((Object)widget)).setParent(parent);
        ((PropertyEditorItemWidget)Mockito.verify((Object)itemWidget)).add((Widget)widget);
    }

    @Test
    public void createAccordionGroupTest() {
        PropertyEditorWidget propertyEditorWidget = (PropertyEditorWidget)GWT.create(PropertyEditorWidget.class);
        PropertyEditorCategory category = new PropertyEditorCategory("Category");
        AccordionGroup accordionGroup = PropertyEditorHelper.createAccordionGroup((PropertyEditorWidget)propertyEditorWidget, (PropertyEditorCategory)category);
        ((AccordionGroup)Mockito.verify((Object)accordionGroup)).setHeading("Category");
        ((AccordionGroup)Mockito.verify((Object)accordionGroup)).addShowHandler((ShowHandler)Mockito.any(ShowHandler.class));
    }

    @Test
    public void createOpenAccordionGroupTest() {
        PropertyEditorWidget propertyEditorWidget = (PropertyEditorWidget)GWT.create(PropertyEditorWidget.class);
        Mockito.when((Object)propertyEditorWidget.getLastOpenAccordionGroupTitle()).thenReturn((Object)"Category");
        PropertyEditorCategory category = new PropertyEditorCategory("Category");
        AccordionGroup accordionGroup = PropertyEditorHelper.createAccordionGroup((PropertyEditorWidget)propertyEditorWidget, (PropertyEditorCategory)category);
        ((AccordionGroup)Mockito.verify((Object)accordionGroup)).setHeading("Category");
        ((AccordionGroup)Mockito.verify((Object)accordionGroup)).addShowHandler((ShowHandler)Mockito.any(ShowHandler.class));
        ((AccordionGroup)Mockito.verify((Object)accordionGroup)).setDefaultOpen(true);
    }

    @Test
    public void createCategoryWithNoFields() {
        PropertyEditorWidget propertyEditorWidget = (PropertyEditorWidget)GWT.create(PropertyEditorWidget.class);
        Accordion propertyMenu = (Accordion)GWT.create(Accordion.class);
        PropertyEditorCategory category = new PropertyEditorCategory("1");
        PropertyEditorHelper.createCategory((PropertyEditorWidget)propertyEditorWidget, (Accordion)propertyMenu, (PropertyEditorCategory)category, (String)"");
        ((Accordion)Mockito.verify((Object)propertyMenu, (VerificationMode)Mockito.never())).add((Widget)Mockito.any(Widget.class));
    }
}

