/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor.gwt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import javax.inject.Inject;
import org.guvnor.ala.build.maven.config.gwt.GWTCodeServerMavenExecConfig;
import org.guvnor.ala.build.maven.executor.gwt.GWTCodeServerPortLeaser;
import org.guvnor.ala.build.maven.model.MavenBuild;
import org.guvnor.ala.build.maven.util.MavenBuildExecutor;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.exceptions.BuildException;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GWTCodeServerMavenExecConfigExecutor
implements BiFunctionConfigExecutor<MavenBuild, GWTCodeServerMavenExecConfig, MavenBuild> {
    protected static final Logger LOG = LoggerFactory.getLogger(GWTCodeServerMavenExecConfigExecutor.class);
    private static final String GWT_CODE_SERVER_PORT = "gwt.codeServerPort";
    private static final String GWT_CODE_SERVER_LAUNCHER_DIR = "gwt.codeServer.launcherDir";
    private static final String GWT_CODE_SERVER_BIND_ADDRESS = "gwt.bindAddress";
    private boolean isCodeServerReady = false;
    private volatile Throwable error = null;
    private GWTCodeServerPortLeaser leaser;

    @Inject
    public GWTCodeServerMavenExecConfigExecutor(GWTCodeServerPortLeaser leaser) {
        this.leaser = leaser;
    }

    public Optional<MavenBuild> apply(MavenBuild buildConfig, GWTCodeServerMavenExecConfig config) {
        File projectFolder = new File(buildConfig.getProject().getTempDir());
        File webappFolder = new File(projectFolder.getAbsolutePath(), "src/main/webapp");
        if (!this.leaser.isCodeServerRunning(buildConfig.getProject().getName())) {
            LOG.info("> Starting GWT Code Server ... ");
            File pom = new File(projectFolder, "pom.xml");
            ArrayList<String> goals = new ArrayList<String>();
            goals.add("gwt:run-codeserver");
            Properties properties = new Properties(buildConfig.getProperties());
            properties.put(GWT_CODE_SERVER_LAUNCHER_DIR, webappFolder.getAbsolutePath());
            Integer portNumber = this.leaser.getAvailableCodeServerPort().getPortNumber();
            this.leaser.setCodeServerForProject(buildConfig.getProject().getName(), portNumber);
            properties.put(GWT_CODE_SERVER_PORT, String.valueOf(portNumber));
            properties.put(GWT_CODE_SERVER_BIND_ADDRESS, config.getBindAddress());
            this.build(pom, properties, goals);
        } else {
            LOG.info("> No need to start GWT Code Server.");
        }
        return Optional.of(buildConfig);
    }

    public Class<? extends Config> executeFor() {
        return GWTCodeServerMavenExecConfig.class;
    }

    public String outputId() {
        return "codeServer";
    }

    public String inputId() {
        return "gwt-codeserver-config";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(File pom, Properties properties, List<String> goals) throws BuildException {
        BufferedReader bufferedReader = null;
        try {
            StringBuilder sb = new StringBuilder();
            PipedOutputStream baosOut = new PipedOutputStream();
            PipedOutputStream baosErr = new PipedOutputStream();
            PrintStream out = new PrintStream(baosOut, true);
            PrintStream err = new PrintStream(baosErr, true);
            new Thread(() -> MavenBuildExecutor.executeMaven(pom, out, err, properties, goals.toArray(new String[0]))).start();
            while (!this.isCodeServerReady && this.error == null) {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(new PipedInputStream(baosOut)));
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line).append("\n");
                    if (!line.contains("The code server is ready at")) continue;
                    this.isCodeServerReady = true;
                    out.close();
                    err.close();
                    baosOut.close();
                    baosErr.close();
                    LOG.info("> Code Server Started Succesfully.");
                }
            }
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(GWTCodeServerMavenExecConfigExecutor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(GWTCodeServerMavenExecConfigExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

