/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;

public class MavenTestUtils {
    public static String createGitRepoWithPom(File path, File ... files) throws Exception {
        InputStream pom = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-pom.xml");
        return MavenTestUtils.createGitRepoWithPom(path, pom, files);
    }

    public static String createGitRepoWithPom(File path, InputStream pom, File ... files) throws Exception {
        File repo = new File(path, "repo");
        if (!repo.exists()) {
            Files.createDirectory(repo.toPath(), new FileAttribute[0]);
        }
        Git git = Git.init().setDirectory(repo).call();
        String gitUrl = "file://" + repo.getAbsolutePath();
        FileUtils.copyInputStreamToFile((InputStream)pom, (File)new File(repo, "pom.xml"));
        AddCommand add = git.add();
        add.addFilepattern("pom.xml");
        for (File f : files) {
            add.addFilepattern(f.getName());
        }
        add.call();
        CommitCommand commit = git.commit();
        commit.setMessage("initial commit").call();
        return gitUrl;
    }
}

