/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.guvnor.ala.build.maven.executor.MavenTestUtils;
import org.guvnor.ala.build.maven.util.RepositoryVisitor;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.registry.inmemory.InMemorySourceRegistry;
import org.guvnor.ala.source.Source;
import org.guvnor.ala.source.git.config.GitConfig;
import org.guvnor.ala.source.git.config.impl.GitConfigImpl;
import org.guvnor.ala.source.git.executor.GitConfigExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.io.impl.IOServiceNio2WrapperImpl;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class RepositoryVisitorTest {
    private File tempPath;
    private String gitUrl;

    @Before
    public void setUp() throws Exception {
        this.tempPath = Files.createTempDirectory("yyy", new FileAttribute[0]).toFile();
        File repo = new File(this.tempPath, "repo");
        repo.mkdirs();
        File iml = new File(repo, "demo.iml");
        iml.createNewFile();
        this.gitUrl = MavenTestUtils.createGitRepoWithPom(this.tempPath, iml);
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Test
    public void repositoryVisitorDiffDeletedTest() throws IOException {
        IOServiceNio2WrapperImpl ioService = new IOServiceNio2WrapperImpl();
        Optional sourceOptional = new GitConfigExecutor((SourceRegistry)new InMemorySourceRegistry()).apply((GitConfig)new GitConfigImpl(this.tempPath.getAbsolutePath(), "master", this.gitUrl, "users-new", "true"));
        Assert.assertTrue((boolean)sourceOptional.isPresent());
        Source source = (Source)sourceOptional.get();
        InputStream pomStream = org.uberfire.java.nio.file.Files.newInputStream((Path)source.getPath().resolve("pom.xml"), (OpenOption[])new OpenOption[0]);
        MavenProject project = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
        RepositoryVisitor repositoryVisitor = new RepositoryVisitor(source.getPath(), project.getName());
        System.out.println("Root: " + repositoryVisitor.getRoot().getAbsolutePath());
        Map identityHash = repositoryVisitor.getIdentityHash();
        URI originRepo = URI.create("git://users-new");
        FileSystem fs = FileSystems.getFileSystem((URI)originRepo);
        ioService.startBatch(fs);
        ioService.write(fs.getPath("/file.txt", new String[0]), "temp", new OpenOption[0]);
        ioService.write(fs.getPath("/pom.xml", new String[0]), "hi there" + UUID.randomUUID().toString(), new OpenOption[0]);
        ioService.endBatch();
        ioService.delete(source.getPath().resolve("demo.iml"), new DeleteOption[0]);
        RepositoryVisitor newRepositoryVisitor = new RepositoryVisitor(source.getPath(), repositoryVisitor.getRoot().getAbsolutePath().trim(), false);
        System.out.println("Root: " + newRepositoryVisitor.getRoot().getAbsolutePath());
        Map newIdentityHash = newRepositoryVisitor.getIdentityHash();
        MapDifference difference = Maps.difference((Map)identityHash, (Map)newIdentityHash);
        Map entriesDiffering = difference.entriesDiffering();
        System.out.println(" Size of Differences: " + entriesDiffering.size());
        for (Object key : entriesDiffering.keySet()) {
            System.out.println("Different Value: " + (String)key);
        }
        Assert.assertEquals((long)1L, (long)entriesDiffering.size());
        Assert.assertNotNull(entriesDiffering.get("/pom.xml"));
        Map deletedFiles = difference.entriesOnlyOnLeft();
        System.out.println(" Size of Deleted Files: " + deletedFiles.size());
        for (String key : deletedFiles.keySet()) {
            System.out.println("Deleted File: " + key);
        }
        Assert.assertEquals((long)1L, (long)deletedFiles.size());
        Assert.assertNotNull(deletedFiles.get("/demo.iml"));
        Map addedFiles = difference.entriesOnlyOnRight();
        System.out.println(" Size of added Files: " + addedFiles.size());
        for (String key : addedFiles.keySet()) {
            System.out.println("Added File: " + key);
        }
        Assert.assertEquals((long)1L, (long)addedFiles.size());
        Assert.assertNotNull(addedFiles.get("/file.txt"));
    }
}

