/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.docker.executor;

import java.util.Optional;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.docker.config.DockerProviderConfig;
import org.guvnor.ala.docker.config.impl.DockerProviderConfigImpl;
import org.guvnor.ala.docker.model.DockerProvider;
import org.guvnor.ala.docker.model.DockerProviderImpl;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderBuilder;
import org.guvnor.ala.runtime.providers.ProviderDestroyer;
import org.guvnor.ala.runtime.providers.ProviderId;

public class DockerProviderConfigExecutor
implements ProviderBuilder<DockerProviderConfig, DockerProvider>,
ProviderDestroyer,
FunctionConfigExecutor<DockerProviderConfig, DockerProvider> {
    private RuntimeRegistry runtimeRegistry;

    @Inject
    public DockerProviderConfigExecutor(RuntimeRegistry runtimeRegistry) {
        this.runtimeRegistry = runtimeRegistry;
    }

    public Optional<DockerProvider> apply(DockerProviderConfig dockerProviderConfig) {
        DockerProviderImpl provider = new DockerProviderImpl(new DockerProviderConfigImpl(dockerProviderConfig.getName(), dockerProviderConfig.getHostIp()));
        this.runtimeRegistry.registerProvider((Provider)provider);
        return Optional.of(provider);
    }

    public Class<? extends Config> executeFor() {
        return DockerProviderConfig.class;
    }

    public String outputId() {
        return "docker-provider";
    }

    public boolean supports(ProviderConfig config) {
        return config instanceof DockerProviderConfig;
    }

    public boolean supports(ProviderId providerId) {
        return providerId instanceof DockerProvider;
    }

    public void destroy(ProviderId providerId) {
    }
}

