/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.docker.executor;

import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.docker.access.DockerAccessInterface;
import org.guvnor.ala.docker.config.DockerProviderConfig;
import org.guvnor.ala.docker.config.DockerRuntimeConfig;
import org.guvnor.ala.docker.config.DockerRuntimeExecConfig;
import org.guvnor.ala.docker.model.DockerProvider;
import org.guvnor.ala.docker.model.DockerRuntime;
import org.guvnor.ala.docker.model.DockerRuntimeEndpoint;
import org.guvnor.ala.docker.model.DockerRuntimeInfo;
import org.guvnor.ala.docker.model.DockerRuntimeState;
import org.guvnor.ala.exceptions.ProvisioningException;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.RuntimeBuilder;
import org.guvnor.ala.runtime.RuntimeDestroyer;
import org.guvnor.ala.runtime.RuntimeEndpoint;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.RuntimeInfo;
import org.guvnor.ala.runtime.RuntimeState;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.util.RuntimeConfigHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRuntimeExecExecutor<T extends DockerRuntimeConfig>
implements RuntimeBuilder<T, DockerRuntime>,
RuntimeDestroyer,
FunctionConfigExecutor<T, DockerRuntime> {
    private final RuntimeRegistry runtimeRegistry;
    private final DockerAccessInterface docker;
    protected static final Logger LOG = LoggerFactory.getLogger(DockerRuntimeExecExecutor.class);

    @Inject
    public DockerRuntimeExecExecutor(RuntimeRegistry runtimeRegistry, DockerAccessInterface docker) {
        this.runtimeRegistry = runtimeRegistry;
        this.docker = docker;
    }

    public Optional<DockerRuntime> apply(DockerRuntimeConfig config) {
        Optional<DockerRuntime> runtime = this.create(config);
        runtime.ifPresent(arg_0 -> ((RuntimeRegistry)this.runtimeRegistry).registerRuntime(arg_0));
        return runtime;
    }

    private Optional<DockerRuntime> create(DockerRuntimeConfig runtimeConfig) throws ProvisioningException {
        ContainerCreation creation;
        if (runtimeConfig.isPull()) {
            try {
                LOG.info("Pulling Docker Image: " + runtimeConfig.getImage());
                this.docker.getDockerClient(runtimeConfig.getProviderId()).pull(runtimeConfig.getImage());
            }
            catch (DockerException | InterruptedException ex) {
                LOG.error(ex.getMessage(), ex);
                throw new ProvisioningException("Error Pulling Docker Image: " + runtimeConfig.getImage() + "with error: " + ex.getMessage());
            }
        }
        String[] ports = new String[]{runtimeConfig.getPort()};
        HashMap portBindings = new HashMap();
        Optional _dockerProvider = this.runtimeRegistry.getProvider(runtimeConfig.getProviderId(), DockerProvider.class);
        if (!_dockerProvider.isPresent()) {
            return Optional.empty();
        }
        DockerProvider dockerProvider = (DockerProvider)_dockerProvider.get();
        ArrayList<PortBinding> randomPort = new ArrayList<PortBinding>();
        PortBinding randomPortBinding = PortBinding.randomPort((String)((DockerProviderConfig)dockerProvider.getConfig()).getHostIp());
        randomPort.add(randomPortBinding);
        portBindings.put(runtimeConfig.getPort(), randomPort);
        HostConfig hostConfig = HostConfig.builder().portBindings(portBindings).build();
        ContainerConfig containerConfig = ContainerConfig.builder().hostConfig(hostConfig).image(runtimeConfig.getImage()).exposedPorts(ports).build();
        try {
            creation = this.docker.getDockerClient(runtimeConfig.getProviderId()).createContainer(containerConfig);
            this.docker.getDockerClient(runtimeConfig.getProviderId()).startContainer(creation.id());
        }
        catch (DockerException | InterruptedException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new ProvisioningException("Error Creating Docker Container with image: " + runtimeConfig.getImage() + "with error: " + ex.getMessage(), ex);
        }
        String id = creation.id();
        String shortId = id.substring(0, 12);
        String host = "";
        try {
            this.docker.getDockerClient(runtimeConfig.getProviderId()).inspectContainer(id);
            host = this.docker.getDockerClient(runtimeConfig.getProviderId()).getHost();
        }
        catch (DockerException | InterruptedException ex) {
            throw new ProvisioningException("Error Getting Docker Container info: " + id + "with error: " + ex.getMessage(), ex);
        }
        DockerRuntimeEndpoint dockerRuntimeEndpoint = new DockerRuntimeEndpoint();
        dockerRuntimeEndpoint.setHost(host);
        dockerRuntimeEndpoint.setPort(Integer.valueOf(runtimeConfig.getPort()));
        dockerRuntimeEndpoint.setContext("");
        return Optional.of(new DockerRuntime(shortId, RuntimeConfigHelper.buildRuntimeName((RuntimeConfig)runtimeConfig, (String)shortId), runtimeConfig, (ProviderId)dockerProvider, (RuntimeEndpoint)dockerRuntimeEndpoint, (RuntimeInfo)new DockerRuntimeInfo(), (RuntimeState)new DockerRuntimeState("RUNNING", new Date().toString())));
    }

    public Class<? extends Config> executeFor() {
        return DockerRuntimeExecConfig.class;
    }

    public String outputId() {
        return "docker-runtime";
    }

    public boolean supports(RuntimeConfig config) {
        return config instanceof DockerRuntimeConfig;
    }

    public boolean supports(RuntimeId runtimeId) {
        return runtimeId instanceof DockerRuntime || this.runtimeRegistry.getRuntimeById(runtimeId.getId()) instanceof DockerRuntime;
    }

    public void destroy(RuntimeId runtimeId) {
        try {
            LOG.info("Killing Container: " + runtimeId.getId());
            this.docker.getDockerClient(runtimeId.getProviderId()).killContainer(runtimeId.getId());
            LOG.info("Removing Container: " + runtimeId.getId());
            this.docker.getDockerClient(runtimeId.getProviderId()).removeContainer(runtimeId.getId());
            this.runtimeRegistry.deregisterRuntime(runtimeId);
        }
        catch (DockerException | InterruptedException ex) {
            LOG.debug(ex.getMessage(), ex);
            try {
                LOG.info("Attempting to Remove Container without Killing: " + runtimeId.getId());
                this.docker.getDockerClient(runtimeId.getProviderId()).removeContainer(runtimeId.getId());
                this.runtimeRegistry.deregisterRuntime(runtimeId);
            }
            catch (DockerException | InterruptedException ex2) {
                LOG.error(ex.getMessage(), ex2);
                throw new ProvisioningException("Error destroying Docker Runtime: " + ex.getMessage(), ex2);
            }
        }
    }
}

