/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.openshift.api.model.NamedRoleBinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonAnyGetter;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonAnySetter;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonIgnore;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonInclude;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonProperty;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonPropertyOrder;
import org.kie.workbench.ala.openshift.jackson.databind.JsonDeserializer;
import org.kie.workbench.ala.openshift.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "lastModified", "policyRef", "roleBindings"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class PolicyBinding
implements HasMetadata {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1";
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "PolicyBinding";
    @JsonProperty(value="lastModified")
    private String lastModified;
    @JsonProperty(value="metadata")
    @Valid
    @CheckObjectMeta(minimal=true)
    private ObjectMeta metadata;
    @JsonProperty(value="policyRef")
    @Valid
    private ObjectReference policyRef;
    @JsonProperty(value="roleBindings")
    @Valid
    private List<NamedRoleBinding> roleBindings = new ArrayList<NamedRoleBinding>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public PolicyBinding() {
    }

    public PolicyBinding(String apiVersion, String kind, String lastModified, ObjectMeta metadata, ObjectReference policyRef, List<NamedRoleBinding> roleBindings) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.lastModified = lastModified;
        this.metadata = metadata;
        this.policyRef = policyRef;
        this.roleBindings = roleBindings;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="lastModified")
    public String getLastModified() {
        return this.lastModified;
    }

    @JsonProperty(value="lastModified")
    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="policyRef")
    public ObjectReference getPolicyRef() {
        return this.policyRef;
    }

    @JsonProperty(value="policyRef")
    public void setPolicyRef(ObjectReference policyRef) {
        this.policyRef = policyRef;
    }

    @JsonProperty(value="roleBindings")
    public List<NamedRoleBinding> getRoleBindings() {
        return this.roleBindings;
    }

    @JsonProperty(value="roleBindings")
    public void setRoleBindings(List<NamedRoleBinding> roleBindings) {
        this.roleBindings = roleBindings;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "PolicyBinding(apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", lastModified=" + this.getLastModified() + ", metadata=" + this.getMetadata() + ", policyRef=" + this.getPolicyRef() + ", roleBindings=" + this.getRoleBindings() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolicyBinding)) {
            return false;
        }
        PolicyBinding other = (PolicyBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        String this$lastModified = this.getLastModified();
        String other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !this$lastModified.equals(other$lastModified)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        ObjectReference this$policyRef = this.getPolicyRef();
        ObjectReference other$policyRef = other.getPolicyRef();
        if (this$policyRef == null ? other$policyRef != null : !((Object)this$policyRef).equals(other$policyRef)) {
            return false;
        }
        List<NamedRoleBinding> this$roleBindings = this.getRoleBindings();
        List<NamedRoleBinding> other$roleBindings = other.getRoleBindings();
        if (this$roleBindings == null ? other$roleBindings != null : !((Object)this$roleBindings).equals(other$roleBindings)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PolicyBinding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        String $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : $lastModified.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        ObjectReference $policyRef = this.getPolicyRef();
        result = result * 59 + ($policyRef == null ? 43 : ((Object)$policyRef).hashCode());
        List<NamedRoleBinding> $roleBindings = this.getRoleBindings();
        result = result * 59 + ($roleBindings == null ? 43 : ((Object)$roleBindings).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

